/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList;
import io.grpc.netty.shaded.io.netty.handler.codec.EncoderException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.PromiseCombiner;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        block18: {
            CodecOutputList codecOutputList = null;
            try {
                if (this.acceptOutboundMessage(object)) {
                    codecOutputList = CodecOutputList.newInstance();
                    Object object2 = object;
                    try {
                        this.encode(channelHandlerContext, object2, codecOutputList);
                    }
                    finally {
                        ReferenceCountUtil.release(object2);
                    }
                    if (codecOutputList.isEmpty()) {
                        codecOutputList.recycle();
                        codecOutputList = null;
                        throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                    }
                    break block18;
                }
                channelHandlerContext.write(object, channelPromise);
            }
            catch (EncoderException encoderException) {
                throw encoderException;
            }
            catch (Throwable throwable) {
                throw new EncoderException(throwable);
            }
            finally {
                if (codecOutputList != null) {
                    int n4 = codecOutputList.size() - 1;
                    if (n4 == 0) {
                        channelHandlerContext.write(codecOutputList.getUnsafe(0), channelPromise);
                    } else if (n4 > 0) {
                        if (channelPromise == channelHandlerContext.voidPromise()) {
                            MessageToMessageEncoder.writeVoidPromise(channelHandlerContext, codecOutputList);
                        } else {
                            MessageToMessageEncoder.writePromiseCombiner(channelHandlerContext, codecOutputList, channelPromise);
                        }
                    }
                    codecOutputList.recycle();
                }
            }
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList) {
        ChannelPromise channelPromise = channelHandlerContext.voidPromise();
        for (int i3 = 0; i3 < codecOutputList.size(); ++i3) {
            channelHandlerContext.write(codecOutputList.getUnsafe(i3), channelPromise);
        }
    }

    private static void writePromiseCombiner(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, ChannelPromise channelPromise) {
        PromiseCombiner promiseCombiner = new PromiseCombiner(channelHandlerContext.executor());
        for (int i3 = 0; i3 < codecOutputList.size(); ++i3) {
            promiseCombiner.add(channelHandlerContext.write(codecOutputList.getUnsafe(i3)));
        }
        promiseCombiner.finish(channelPromise);
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

