/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufHolder;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResultProvider;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageAggregationException;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageAggregator$1;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;

    protected MessageAggregator(int n4) {
        MessageAggregator.validateMaxContentLength(n4);
        this.maxContentLength = n4;
    }

    protected MessageAggregator(int n4, Class<? extends I> clazz) {
        super(clazz);
        MessageAggregator.validateMaxContentLength(n4);
        this.maxContentLength = n4;
    }

    private static void validateMaxContentLength(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        Object object2 = object;
        if (this.isAggregated(object2)) {
            return false;
        }
        if (this.isStartMessage(object2)) {
            this.aggregating = true;
            return true;
        }
        return this.aggregating && this.isContentMessage(object2);
    }

    protected abstract boolean isStartMessage(I var1);

    protected abstract boolean isContentMessage(I var1);

    protected abstract boolean isLastContentMessage(C var1);

    protected abstract boolean isAggregated(I var1);

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    public final int maxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int n4) {
        if (n4 < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + n4 + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = n4;
    }

    @Deprecated
    public final boolean isHandlingOversizedMessage() {
        return this.handlingOversizedMessage;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, I i3, List<Object> list) {
        assert (this.aggregating);
        if (this.isStartMessage(i3)) {
            Object object;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I i8 = i3;
            Object object2 = this.newContinueResponse(i8, this.maxContentLength, channelHandlerContext.pipeline());
            if (object2 != null) {
                object = this.continueResponseWriteListener;
                if (object == null) {
                    object = new MessageAggregator$1(this, channelHandlerContext);
                    this.continueResponseWriteListener = object;
                }
                boolean bl3 = this.closeAfterContinueResponse(object2);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object2);
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2).addListener((GenericFutureListener<? extends Future<? super Void>>)object);
                if (bl3) {
                    channelFuture.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(i8, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, i8);
                return;
            }
            if (i8 instanceof DecoderResultProvider && !((DecoderResultProvider)i8).decoderResult().isSuccess()) {
                object = i8 instanceof ByteBufHolder ? this.beginAggregation(i8, ((ByteBufHolder)i8).content().retain()) : this.beginAggregation(i8, Unpooled.EMPTY_BUFFER);
                this.finishAggregation0(object);
                list.add(object);
                return;
            }
            object = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (i8 instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object, ((ByteBufHolder)i8).content());
            }
            this.currentMessage = this.beginAggregation(i8, (ByteBuf)object);
        } else if (this.isContentMessage(i3)) {
            boolean bl4;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            ByteBufHolder byteBufHolder = (ByteBufHolder)i3;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - byteBufHolder.content().readableBytes()) {
                O o4 = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o4);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, byteBufHolder.content());
            this.aggregate(this.currentMessage, byteBufHolder);
            if (byteBufHolder instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)((Object)byteBufHolder)).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl4 = true;
                } else {
                    bl4 = this.isLastContentMessage(byteBufHolder);
                }
            } else {
                bl4 = this.isLastContentMessage(byteBufHolder);
            }
            if (bl4) {
                this.finishAggregation0(this.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
        } else {
            throw new MessageAggregationException();
        }
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2);

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3);

    protected abstract boolean closeAfterContinueResponse(Object var1);

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1);

    protected abstract O beginAggregation(S var1, ByteBuf var2);

    protected void aggregate(O o4, C c10) {
    }

    private void finishAggregation0(O o4) {
        this.aggregating = false;
        this.finishAggregation(o4);
    }

    protected void finishAggregation(O o4) {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s11) {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        try {
            this.handleOversizedMessage(channelHandlerContext, s11);
        }
        finally {
            ReferenceCountUtil.release(s11);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s11) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            super.channelInactive(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            super.handlerRemoved(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

