/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import java.util.List;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;
    private int offset;

    public LineBasedFrameDecoder(int n4) {
        this(n4, true, false);
    }

    public LineBasedFrameDecoder(int n4, boolean bl3, boolean bl4) {
        this.maxLength = n4;
        this.failFast = bl4;
        this.stripDelimiter = bl3;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n4 = this.findEndOfLine(byteBuf);
        if (!this.discarding) {
            if (n4 >= 0) {
                ByteBuf byteBuf2;
                int n7;
                int n8 = n4 - byteBuf.readerIndex();
                int n10 = n7 = byteBuf.getByte(n4) == 13 ? 2 : 1;
                if (n8 > this.maxLength) {
                    byteBuf.readerIndex(n4 + n7);
                    this.fail(channelHandlerContext, n8);
                    return null;
                }
                if (this.stripDelimiter) {
                    byteBuf2 = byteBuf.readRetainedSlice(n8);
                    byteBuf.skipBytes(n7);
                } else {
                    byteBuf2 = byteBuf.readRetainedSlice(n8 + n7);
                }
                return byteBuf2;
            }
            int n11 = byteBuf.readableBytes();
            if (n11 > this.maxLength) {
                this.discardedBytes = n11;
                byteBuf.readerIndex(byteBuf.writerIndex());
                this.discarding = true;
                this.offset = 0;
                if (this.failFast) {
                    this.fail(channelHandlerContext, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (n4 >= 0) {
            int n12 = this.discardedBytes + n4 - byteBuf.readerIndex();
            int n13 = byteBuf.getByte(n4) == 13 ? 2 : 1;
            byteBuf.readerIndex(n4 + n13);
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                this.fail(channelHandlerContext, n12);
            }
        } else {
            this.discardedBytes += byteBuf.readableBytes();
            byteBuf.readerIndex(byteBuf.writerIndex());
            this.offset = 0;
        }
        return null;
    }

    private void fail(ChannelHandlerContext channelHandlerContext, int n4) {
        this.fail(channelHandlerContext, String.valueOf(n4));
    }

    private void fail(ChannelHandlerContext channelHandlerContext, String string) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("frame length (" + string + ") exceeds the allowed maximum (" + this.maxLength + ')'));
    }

    private int findEndOfLine(ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        int n7 = byteBuf.forEachByte(byteBuf.readerIndex() + this.offset, n4 - this.offset, ByteProcessor.FIND_LF);
        if (n7 >= 0) {
            this.offset = 0;
            if (n7 > 0 && byteBuf.getByte(n7 - 1) == 13) {
                --n7;
            }
        } else {
            this.offset = n4;
        }
        return n7;
    }
}

