/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;

@ChannelHandler$Sharable
public class LengthFieldPrepender
extends MessageToMessageEncoder<ByteBuf> {
    private final ByteOrder byteOrder;
    private final int lengthFieldLength;
    private final boolean lengthIncludesLengthFieldLength;
    private final int lengthAdjustment;

    public LengthFieldPrepender(int n4) {
        this(n4, false);
    }

    public LengthFieldPrepender(int n4, boolean bl3) {
        this(n4, 0, bl3);
    }

    public LengthFieldPrepender(int n4, int n7) {
        this(n4, n7, false);
    }

    public LengthFieldPrepender(int n4, int n7, boolean bl3) {
        this(ByteOrder.BIG_ENDIAN, n4, n7, bl3);
    }

    public LengthFieldPrepender(ByteOrder byteOrder, int n4, int n7, boolean bl3) {
        if (n4 != 1 && n4 != 2 && n4 != 3 && n4 != 4 && n4 != 8) {
            throw new IllegalArgumentException("lengthFieldLength must be either 1, 2, 3, 4, or 8: " + n4);
        }
        ObjectUtil.checkNotNull(byteOrder, "byteOrder");
        this.byteOrder = byteOrder;
        this.lengthFieldLength = n4;
        this.lengthIncludesLengthFieldLength = bl3;
        this.lengthAdjustment = n7;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n4 = byteBuf.readableBytes() + this.lengthAdjustment;
        if (this.lengthIncludesLengthFieldLength) {
            n4 += this.lengthFieldLength;
        }
        ObjectUtil.checkPositiveOrZero(n4, "length");
        switch (this.lengthFieldLength) {
            case 1: {
                if (n4 >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + n4);
                }
                list.add(channelHandlerContext.alloc().buffer(1).order(this.byteOrder).writeByte((byte)n4));
                break;
            }
            case 2: {
                if (n4 >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + n4);
                }
                list.add(channelHandlerContext.alloc().buffer(2).order(this.byteOrder).writeShort((short)n4));
                break;
            }
            case 3: {
                if (n4 >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + n4);
                }
                list.add(channelHandlerContext.alloc().buffer(3).order(this.byteOrder).writeMedium(n4));
                break;
            }
            case 4: {
                list.add(channelHandlerContext.alloc().buffer(4).order(this.byteOrder).writeInt(n4));
                break;
            }
            case 8: {
                list.add(channelHandlerContext.alloc().buffer(8).order(this.byteOrder).writeLong(n4));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        list.add(byteBuf.retain());
    }
}

