/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.CorruptedFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;

public class LengthFieldBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;
    private long bytesToDiscard;

    public LengthFieldBasedFrameDecoder(int n4, int n7, int n8) {
        this(n4, n7, n8, 0, 0);
    }

    public LengthFieldBasedFrameDecoder(int n4, int n7, int n8, int n10, int n11) {
        this(n4, n7, n8, n10, n11, true);
    }

    public LengthFieldBasedFrameDecoder(int n4, int n7, int n8, int n10, int n11, boolean bl3) {
        this(ByteOrder.BIG_ENDIAN, n4, n7, n8, n10, n11, bl3);
    }

    public LengthFieldBasedFrameDecoder(ByteOrder byteOrder, int n4, int n7, int n8, int n10, int n11, boolean bl3) {
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        ObjectUtil.checkPositive(n4, "maxFrameLength");
        ObjectUtil.checkPositiveOrZero(n7, "lengthFieldOffset");
        ObjectUtil.checkPositiveOrZero(n11, "initialBytesToStrip");
        if (n7 > n4 - n8) {
            throw new IllegalArgumentException("maxFrameLength (" + n4 + ") must be equal to or greater than lengthFieldOffset (" + n7 + ") + lengthFieldLength (" + n8 + ").");
        }
        this.byteOrder = byteOrder;
        this.maxFrameLength = n4;
        this.lengthFieldOffset = n7;
        this.lengthFieldLength = n8;
        this.lengthAdjustment = n10;
        this.lengthFieldEndOffset = n7 + n8;
        this.initialBytesToStrip = n11;
        this.failFast = bl3;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    private void discardingTooLongFrame(ByteBuf byteBuf) {
        long l2 = this.bytesToDiscard;
        int n4 = (int)Math.min(l2, (long)byteBuf.readableBytes());
        byteBuf.skipBytes(n4);
        this.bytesToDiscard = l2 -= (long)n4;
        this.failIfNecessary(false);
    }

    private static void failOnNegativeLengthField(ByteBuf byteBuf, long l2, int n4) {
        byteBuf.skipBytes(n4);
        throw new CorruptedFrameException("negative pre-adjustment length field: " + l2);
    }

    private static void failOnFrameLengthLessThanLengthFieldEndOffset(ByteBuf byteBuf, long l2, int n4) {
        byteBuf.skipBytes(n4);
        throw new CorruptedFrameException("Adjusted frame length (" + l2 + ") is less than lengthFieldEndOffset: " + n4);
    }

    private void exceededFrameLength(ByteBuf byteBuf, long l2) {
        long l10 = l2 - (long)byteBuf.readableBytes();
        this.tooLongFrameLength = l2;
        if (l10 < 0L) {
            byteBuf.skipBytes((int)l2);
        } else {
            this.discardingTooLongFrame = true;
            this.bytesToDiscard = l10;
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
        this.failIfNecessary(true);
    }

    private static void failOnFrameLengthLessThanInitialBytesToStrip(ByteBuf byteBuf, long l2, int n4) {
        byteBuf.skipBytes((int)l2);
        throw new CorruptedFrameException("Adjusted frame length (" + l2 + ") is less than initialBytesToStrip: " + n4);
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.discardingTooLongFrame) {
            this.discardingTooLongFrame(byteBuf);
        }
        if (byteBuf.readableBytes() < this.lengthFieldEndOffset) {
            return null;
        }
        int n4 = byteBuf.readerIndex() + this.lengthFieldOffset;
        long l2 = this.getUnadjustedFrameLength(byteBuf, n4, this.lengthFieldLength, this.byteOrder);
        if (l2 < 0L) {
            LengthFieldBasedFrameDecoder.failOnNegativeLengthField(byteBuf, l2, this.lengthFieldEndOffset);
        }
        if ((l2 += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanLengthFieldEndOffset(byteBuf, l2, this.lengthFieldEndOffset);
        }
        if (l2 > (long)this.maxFrameLength) {
            this.exceededFrameLength(byteBuf, l2);
            return null;
        }
        int n7 = (int)l2;
        if (byteBuf.readableBytes() < n7) {
            return null;
        }
        if (this.initialBytesToStrip > n7) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanInitialBytesToStrip(byteBuf, l2, this.initialBytesToStrip);
        }
        byteBuf.skipBytes(this.initialBytesToStrip);
        int n8 = byteBuf.readerIndex();
        int n10 = n7 - this.initialBytesToStrip;
        ByteBuf byteBuf2 = this.extractFrame(channelHandlerContext, byteBuf, n8, n10);
        byteBuf.readerIndex(n8 + n10);
        return byteBuf2;
    }

    protected long getUnadjustedFrameLength(ByteBuf byteBuf, int n4, int n7, ByteOrder byteOrder) {
        long l2;
        byteBuf = byteBuf.order(byteOrder);
        switch (n7) {
            case 1: {
                l2 = byteBuf.getUnsignedByte(n4);
                break;
            }
            case 2: {
                l2 = byteBuf.getUnsignedShort(n4);
                break;
            }
            case 3: {
                l2 = byteBuf.getUnsignedMedium(n4);
                break;
            }
            case 4: {
                l2 = byteBuf.getUnsignedInt(n4);
                break;
            }
            case 8: {
                l2 = byteBuf.getLong(n4);
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.lengthFieldLength + " (expected: 1, 2, 3, 4, or 8)");
            }
        }
        return l2;
    }

    private void failIfNecessary(boolean bl3) {
        if (this.bytesToDiscard == 0L) {
            long l2 = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || bl3) {
                this.fail(l2);
            }
        } else if (this.failFast && bl3) {
            this.fail(this.tooLongFrameLength);
        }
    }

    protected ByteBuf extractFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.retainedSlice(n4, n7);
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

