/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.LineBasedFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int n4, ByteBuf byteBuf) {
        this(n4, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n4, boolean bl3, ByteBuf byteBuf) {
        this(n4, bl3, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n4, boolean bl3, boolean bl4, ByteBuf byteBuf) {
        this(n4, bl3, bl4, new ByteBuf[]{byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes())});
    }

    public DelimiterBasedFrameDecoder(int n4, ByteBuf ... byteBufArray) {
        this(n4, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n4, boolean bl3, ByteBuf ... byteBufArray) {
        this(n4, bl3, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n4, boolean bl3, boolean bl4, ByteBuf ... byteBufArray) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(n4);
        if (byteBufArray == null) {
            throw new NullPointerException("delimiters");
        }
        if (byteBufArray.length == 0) {
            throw new IllegalArgumentException("empty delimiters");
        }
        if (DelimiterBasedFrameDecoder.isLineBased(byteBufArray) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(n4, bl3, bl4);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[byteBufArray.length];
            for (int i3 = 0; i3 < byteBufArray.length; ++i3) {
                ByteBuf byteBuf = byteBufArray[i3];
                DelimiterBasedFrameDecoder.validateDelimiter(byteBuf);
                this.delimiters[i3] = byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = n4;
        this.stripDelimiter = bl3;
        this.failFast = bl4;
    }

    private static boolean isLineBased(ByteBuf[] byteBufArray) {
        if (byteBufArray.length != 2) {
            return false;
        }
        ByteBuf byteBuf = byteBufArray[0];
        ByteBuf byteBuf2 = byteBufArray[1];
        if (byteBuf.capacity() < byteBuf2.capacity()) {
            byteBuf = byteBufArray[1];
            byteBuf2 = byteBufArray[0];
        }
        return byteBuf.capacity() == 2 && byteBuf2.capacity() == 1 && byteBuf.getByte(0) == 13 && byteBuf.getByte(1) == 10 && byteBuf2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return this.getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(channelHandlerContext, byteBuf);
        }
        int n4 = Integer.MAX_VALUE;
        ByteBuf byteBuf2 = null;
        for (ByteBuf byteBuf3 : this.delimiters) {
            int n7 = DelimiterBasedFrameDecoder.indexOf(byteBuf, byteBuf3);
            if (n7 < 0 || n7 >= n4) continue;
            n4 = n7;
            byteBuf2 = byteBuf3;
        }
        if (byteBuf2 != null) {
            ByteBuf byteBuf4;
            int n8 = byteBuf2.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                byteBuf.skipBytes(n4 + n8);
                int n10 = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(n10);
                }
                return null;
            }
            if (n4 > this.maxFrameLength) {
                byteBuf.skipBytes(n4 + n8);
                this.fail(n4);
                return null;
            }
            if (this.stripDelimiter) {
                byteBuf4 = byteBuf.readRetainedSlice(n4);
                byteBuf.skipBytes(n8);
            } else {
                byteBuf4 = byteBuf.readRetainedSlice(n4 + n8);
            }
            return byteBuf4;
        }
        if (!this.discardingTooLongFrame) {
            if (byteBuf.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = byteBuf.readableBytes();
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    this.fail(this.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += byteBuf.readableBytes();
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
        return null;
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        for (int i3 = byteBuf.readerIndex(); i3 < byteBuf.writerIndex(); ++i3) {
            int n4;
            int n7 = i3;
            for (n4 = 0; n4 < byteBuf2.capacity() && byteBuf.getByte(n7) == byteBuf2.getByte(n4); ++n4) {
                if (++n7 != byteBuf.writerIndex() || n4 == byteBuf2.capacity() - 1) continue;
                return -1;
            }
            if (n4 != byteBuf2.capacity()) continue;
            return i3 - byteBuf.readerIndex();
        }
        return -1;
    }

    private static void validateDelimiter(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("delimiter");
        }
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int n4) {
        ObjectUtil.checkPositive(n4, "maxFrameLength");
    }
}

