/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.handler.codec.DefaultHeaders$HeaderEntry;
import io.grpc.netty.shaded.io.netty.handler.codec.DefaultHeaders$HeaderIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.DefaultHeaders$NameValidator;
import io.grpc.netty.shaded.io.netty.handler.codec.DefaultHeaders$ValueIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.HeadersUtils;
import io.grpc.netty.shaded.io.netty.handler.codec.ValueConverter;
import io.grpc.netty.shaded.io.netty.util.HashingStrategy;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    static final int HASH_CODE_SEED = -1028477387;
    private final DefaultHeaders$HeaderEntry<K, V>[] entries;
    public final DefaultHeaders$HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final DefaultHeaders$NameValidator<K> nameValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(ValueConverter<V> valueConverter) {
        this(HashingStrategy.JAVA_HASHER, valueConverter);
    }

    public DefaultHeaders(ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator) {
        this(HashingStrategy.JAVA_HASHER, valueConverter, defaultHeaders$NameValidator);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter) {
        this(hashingStrategy, valueConverter, DefaultHeaders$NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator) {
        this(hashingStrategy, valueConverter, defaultHeaders$NameValidator, 16);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator, int n4) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(defaultHeaders$NameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(hashingStrategy, "nameHashingStrategy");
        this.entries = new DefaultHeaders$HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n4, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new DefaultHeaders$HeaderEntry();
    }

    @Override
    public V get(K k9) {
        ObjectUtil.checkNotNull(k9, "name");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n7];
        V v3 = null;
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n4 && this.hashingStrategy.equals(k9, defaultHeaders$HeaderEntry.key)) {
                v3 = defaultHeaders$HeaderEntry.value;
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return v3;
    }

    @Override
    public V get(K k9, V v3) {
        V v4 = this.get(k9);
        if (v4 == null) {
            return v3;
        }
        return v4;
    }

    @Override
    public V getAndRemove(K k9) {
        int n4 = this.hashingStrategy.hashCode(k9);
        return this.remove0(n4, this.index(n4), ObjectUtil.checkNotNull(k9, "name"));
    }

    @Override
    public V getAndRemove(K k9, V v3) {
        V v4 = this.getAndRemove(k9);
        if (v4 == null) {
            return v3;
        }
        return v4;
    }

    @Override
    public List<V> getAll(K k9) {
        ObjectUtil.checkNotNull(k9, "name");
        LinkedList<V> linkedList = new LinkedList<V>();
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n7];
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n4 && this.hashingStrategy.equals(k9, defaultHeaders$HeaderEntry.key)) {
                linkedList.addFirst(defaultHeaders$HeaderEntry.getValue());
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return linkedList;
    }

    public Iterator<V> valueIterator(K k9) {
        return new DefaultHeaders$ValueIterator(this, k9);
    }

    @Override
    public List<V> getAllAndRemove(K k9) {
        List<V> list = this.getAll(k9);
        this.remove(k9);
        return list;
    }

    @Override
    public boolean contains(K k9) {
        return this.get(k9) != null;
    }

    @Override
    public boolean containsObject(K k9, Object object) {
        return this.contains(k9, this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value")));
    }

    @Override
    public boolean containsBoolean(K k9, boolean bl3) {
        return this.contains(k9, this.valueConverter.convertBoolean(bl3));
    }

    @Override
    public boolean containsByte(K k9, byte by2) {
        return this.contains(k9, this.valueConverter.convertByte(by2));
    }

    @Override
    public boolean containsChar(K k9, char c10) {
        return this.contains(k9, this.valueConverter.convertChar(c10));
    }

    @Override
    public boolean containsShort(K k9, short s11) {
        return this.contains(k9, this.valueConverter.convertShort(s11));
    }

    @Override
    public boolean containsInt(K k9, int n4) {
        return this.contains(k9, this.valueConverter.convertInt(n4));
    }

    @Override
    public boolean containsLong(K k9, long l2) {
        return this.contains(k9, this.valueConverter.convertLong(l2));
    }

    @Override
    public boolean containsFloat(K k9, float f8) {
        return this.contains(k9, this.valueConverter.convertFloat(f8));
    }

    @Override
    public boolean containsDouble(K k9, double d8) {
        return this.contains(k9, this.valueConverter.convertDouble(d8));
    }

    @Override
    public boolean containsTimeMillis(K k9, long l2) {
        return this.contains(k9, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public boolean contains(K k9, V v3) {
        return this.contains(k9, v3, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(K k9, V v3, HashingStrategy<? super V> hashingStrategy) {
        ObjectUtil.checkNotNull(k9, "name");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n7];
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n4 && this.hashingStrategy.equals(k9, defaultHeaders$HeaderEntry.key) && hashingStrategy.equals(v3, defaultHeaders$HeaderEntry.value)) {
                return true;
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.size());
        DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry = this.head.after;
        while (defaultHeaders$HeaderEntry != this.head) {
            linkedHashSet.add(defaultHeaders$HeaderEntry.getKey());
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
        }
        return linkedHashSet;
    }

    @Override
    public T add(K k9, V v3) {
        this.nameValidator.validateName(k9);
        ObjectUtil.checkNotNull(v3, "value");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.add0(n4, n7, k9, v3);
        return this.thisT();
    }

    @Override
    public T add(K k9, Iterable<? extends V> iterable) {
        this.nameValidator.validateName(k9);
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        for (V v3 : iterable) {
            this.add0(n4, n7, k9, v3);
        }
        return this.thisT();
    }

    @Override
    public T add(K k9, V ... VArray) {
        this.nameValidator.validateName(k9);
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        for (V v3 : VArray) {
            this.add0(n4, n7, k9, v3);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k9, Object object) {
        return this.add(k9, this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value")));
    }

    @Override
    public T addObject(K k9, Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.addObject(k9, obj);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k9, Object ... objectArray) {
        for (Object object : objectArray) {
            this.addObject(k9, object);
        }
        return this.thisT();
    }

    @Override
    public T addInt(K k9, int n4) {
        return this.add(k9, this.valueConverter.convertInt(n4));
    }

    @Override
    public T addLong(K k9, long l2) {
        return this.add(k9, this.valueConverter.convertLong(l2));
    }

    @Override
    public T addDouble(K k9, double d8) {
        return this.add(k9, this.valueConverter.convertDouble(d8));
    }

    @Override
    public T addTimeMillis(K k9, long l2) {
        return this.add(k9, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public T addChar(K k9, char c10) {
        return this.add(k9, this.valueConverter.convertChar(c10));
    }

    @Override
    public T addBoolean(K k9, boolean bl3) {
        return this.add(k9, this.valueConverter.convertBoolean(bl3));
    }

    @Override
    public T addFloat(K k9, float f8) {
        return this.add(k9, this.valueConverter.convertFloat(f8));
    }

    @Override
    public T addByte(K k9, byte by2) {
        return this.add(k9, this.valueConverter.convertByte(by2));
    }

    @Override
    public T addShort(K k9, short s11) {
        return this.add(k9, this.valueConverter.convertShort(s11));
    }

    @Override
    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (defaultHeaders$HeaderEntry != defaultHeaders.head) {
                    this.add0(defaultHeaders$HeaderEntry.hash, this.index(defaultHeaders$HeaderEntry.hash), defaultHeaders$HeaderEntry.key, defaultHeaders$HeaderEntry.value);
                    defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
                }
            } else {
                while (defaultHeaders$HeaderEntry != defaultHeaders.head) {
                    this.add((K)defaultHeaders$HeaderEntry.key, (V)defaultHeaders$HeaderEntry.value);
                    defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
                }
            }
        } else {
            for (Map.Entry<K, V> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public T set(K k9, V v3) {
        this.nameValidator.validateName(k9);
        ObjectUtil.checkNotNull(v3, "value");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.remove0(n4, n7, k9);
        this.add0(n4, n7, k9, v3);
        return this.thisT();
    }

    @Override
    public T set(K k9, Iterable<? extends V> iterable) {
        this.nameValidator.validateName(k9);
        ObjectUtil.checkNotNull(iterable, "values");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.remove0(n4, n7, k9);
        for (V v3 : iterable) {
            if (v3 == null) break;
            this.add0(n4, n7, k9, v3);
        }
        return this.thisT();
    }

    @Override
    public T set(K k9, V ... VArray) {
        this.nameValidator.validateName(k9);
        ObjectUtil.checkNotNull(VArray, "values");
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.remove0(n4, n7, k9);
        for (V v3 : VArray) {
            if (v3 == null) break;
            this.add0(n4, n7, k9, v3);
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k9, Object object) {
        ObjectUtil.checkNotNull(object, "value");
        V v3 = ObjectUtil.checkNotNull(this.valueConverter.convertObject(object), "convertedValue");
        return this.set(k9, v3);
    }

    @Override
    public T setObject(K k9, Iterable<?> iterable) {
        this.nameValidator.validateName(k9);
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.remove0(n4, n7, k9);
        for (Object obj : iterable) {
            if (obj == null) break;
            this.add0(n4, n7, k9, this.valueConverter.convertObject(obj));
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k9, Object ... objectArray) {
        this.nameValidator.validateName(k9);
        int n4 = this.hashingStrategy.hashCode(k9);
        int n7 = this.index(n4);
        this.remove0(n4, n7, k9);
        for (Object object : objectArray) {
            if (object == null) break;
            this.add0(n4, n7, k9, this.valueConverter.convertObject(object));
        }
        return this.thisT();
    }

    @Override
    public T setInt(K k9, int n4) {
        return this.set(k9, this.valueConverter.convertInt(n4));
    }

    @Override
    public T setLong(K k9, long l2) {
        return this.set(k9, this.valueConverter.convertLong(l2));
    }

    @Override
    public T setDouble(K k9, double d8) {
        return this.set(k9, this.valueConverter.convertDouble(d8));
    }

    @Override
    public T setTimeMillis(K k9, long l2) {
        return this.set(k9, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public T setFloat(K k9, float f8) {
        return this.set(k9, this.valueConverter.convertFloat(f8));
    }

    @Override
    public T setChar(K k9, char c10) {
        return this.set(k9, this.valueConverter.convertChar(c10));
    }

    @Override
    public T setBoolean(K k9, boolean bl3) {
        return this.set(k9, this.valueConverter.convertBoolean(bl3));
    }

    @Override
    public T setByte(K k9, byte by2) {
        return this.set(k9, this.valueConverter.convertByte(by2));
    }

    @Override
    public T setShort(K k9, short s11) {
        return this.set(k9, this.valueConverter.convertShort(s11));
    }

    @Override
    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public T setAll(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            for (K k9 : headers.names()) {
                this.remove(k9);
            }
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public boolean remove(K k9) {
        return this.getAndRemove(k9) != null;
    }

    @Override
    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new DefaultHeaders$HeaderIterator(this, null);
    }

    @Override
    public Boolean getBoolean(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(K k9, boolean bl3) {
        Boolean bl4 = this.getBoolean(k9);
        return bl4 != null ? bl4 : bl3;
    }

    @Override
    public Byte getByte(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Byte.valueOf(this.valueConverter.convertToByte(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByte(K k9, byte by2) {
        Byte by3 = this.getByte(k9);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getChar(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Character.valueOf(this.valueConverter.convertToChar(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getChar(K k9, char c10) {
        Character c11 = this.getChar(k9);
        return c11 != null ? c11.charValue() : c10;
    }

    @Override
    public Short getShort(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Short.valueOf(this.valueConverter.convertToShort(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShort(K k9, short s11) {
        Short s12 = this.getShort(k9);
        return s12 != null ? s12 : s11;
    }

    @Override
    public Integer getInt(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Integer.valueOf(this.valueConverter.convertToInt(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getInt(K k9, int n4) {
        Integer n7 = this.getInt(k9);
        return n7 != null ? n7 : n4;
    }

    @Override
    public Long getLong(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Long.valueOf(this.valueConverter.convertToLong(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLong(K k9, long l2) {
        Long l10 = this.getLong(k9);
        return l10 != null ? l10 : l2;
    }

    @Override
    public Float getFloat(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Float.valueOf(this.valueConverter.convertToFloat(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloat(K k9, float f8) {
        Float f9 = this.getFloat(k9);
        return f9 != null ? f9.floatValue() : f8;
    }

    @Override
    public Double getDouble(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Double.valueOf(this.valueConverter.convertToDouble(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDouble(K k9, double d8) {
        Double d10 = this.getDouble(k9);
        return d10 != null ? d10 : d8;
    }

    @Override
    public Long getTimeMillis(K k9) {
        V v3 = this.get(k9);
        try {
            return v3 != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(K k9, long l2) {
        Long l10 = this.getTimeMillis(k9);
        return l10 != null ? l10 : l2;
    }

    @Override
    public Boolean getBooleanAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBooleanAndRemove(K k9, boolean bl3) {
        Boolean bl4 = this.getBooleanAndRemove(k9);
        return bl4 != null ? bl4 : bl3;
    }

    @Override
    public Byte getByteAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Byte.valueOf(this.valueConverter.convertToByte(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByteAndRemove(K k9, byte by2) {
        Byte by3 = this.getByteAndRemove(k9);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getCharAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Character.valueOf(this.valueConverter.convertToChar(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(K k9, char c10) {
        Character c11 = this.getCharAndRemove(k9);
        return c11 != null ? c11.charValue() : c10;
    }

    @Override
    public Short getShortAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Short.valueOf(this.valueConverter.convertToShort(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShortAndRemove(K k9, short s11) {
        Short s12 = this.getShortAndRemove(k9);
        return s12 != null ? s12 : s11;
    }

    @Override
    public Integer getIntAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Integer.valueOf(this.valueConverter.convertToInt(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(K k9, int n4) {
        Integer n7 = this.getIntAndRemove(k9);
        return n7 != null ? n7 : n4;
    }

    @Override
    public Long getLongAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Long.valueOf(this.valueConverter.convertToLong(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(K k9, long l2) {
        Long l10 = this.getLongAndRemove(k9);
        return l10 != null ? l10 : l2;
    }

    @Override
    public Float getFloatAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Float.valueOf(this.valueConverter.convertToFloat(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloatAndRemove(K k9, float f8) {
        Float f9 = this.getFloatAndRemove(k9);
        return f9 != null ? f9.floatValue() : f8;
    }

    @Override
    public Double getDoubleAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Double.valueOf(this.valueConverter.convertToDouble(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDoubleAndRemove(K k9, double d8) {
        Double d10 = this.getDoubleAndRemove(k9);
        return d10 != null ? d10 : d8;
    }

    @Override
    public Long getTimeMillisAndRemove(K k9) {
        V v3 = this.getAndRemove(k9);
        try {
            return v3 != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v3)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(K k9, long l2) {
        Long l10 = this.getTimeMillisAndRemove(k9);
        return l10 != null ? l10 : l2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)object, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> headers, HashingStrategy<V> hashingStrategy) {
        if (headers.size() != this.size()) {
            return false;
        }
        if (this == headers) {
            return true;
        }
        for (K k9 : this.names()) {
            List<V> list = headers.getAll(k9);
            List<V> list2 = this.getAll(k9);
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (hashingStrategy.equals(list.get(i3), list2.get(i3))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> hashingStrategy) {
        int n4 = -1028477387;
        for (K k9 : this.names()) {
            n4 = 31 * n4 + this.hashingStrategy.hashCode(k9);
            List<V> list = this.getAll(k9);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                n4 = 31 * n4 + hashingStrategy.hashCode(list.get(i3));
            }
        }
        return n4;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected DefaultHeaders$HeaderEntry<K, V> newHeaderEntry(int n4, K k9, V v3, DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry) {
        return new DefaultHeaders$HeaderEntry<K, V>(n4, k9, v3, defaultHeaders$HeaderEntry, this.head);
    }

    public ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int n4) {
        return n4 & this.hashMask;
    }

    private void add0(int n4, int n7, K k9, V v3) {
        this.entries[n7] = this.newHeaderEntry(n4, k9, v3, this.entries[n7]);
        ++this.size;
    }

    private V remove0(int n4, int n7, K k9) {
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n7];
        if (defaultHeaders$HeaderEntry == null) {
            return null;
        }
        V v3 = null;
        DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry2 = defaultHeaders$HeaderEntry.next;
        while (defaultHeaders$HeaderEntry2 != null) {
            if (defaultHeaders$HeaderEntry2.hash == n4 && this.hashingStrategy.equals(k9, defaultHeaders$HeaderEntry2.key)) {
                v3 = defaultHeaders$HeaderEntry2.value;
                defaultHeaders$HeaderEntry.next = defaultHeaders$HeaderEntry2.next;
                defaultHeaders$HeaderEntry2.remove();
                --this.size;
            } else {
                defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry2;
            }
            defaultHeaders$HeaderEntry2 = defaultHeaders$HeaderEntry.next;
        }
        defaultHeaders$HeaderEntry = this.entries[n7];
        if (defaultHeaders$HeaderEntry.hash == n4 && this.hashingStrategy.equals(k9, defaultHeaders$HeaderEntry.key)) {
            if (v3 == null) {
                v3 = defaultHeaders$HeaderEntry.value;
            }
            this.entries[n7] = defaultHeaders$HeaderEntry.next;
            defaultHeaders$HeaderEntry.remove();
            --this.size;
        }
        return v3;
    }

    private DefaultHeaders$HeaderEntry<K, V> remove0(DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry, DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry2) {
        int n4 = this.index(defaultHeaders$HeaderEntry.hash);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry3 = this.entries[n4];
        if (defaultHeaders$HeaderEntry3 == defaultHeaders$HeaderEntry) {
            this.entries[n4] = defaultHeaders$HeaderEntry.next;
            defaultHeaders$HeaderEntry2 = this.entries[n4];
        } else {
            defaultHeaders$HeaderEntry2.next = defaultHeaders$HeaderEntry.next;
        }
        defaultHeaders$HeaderEntry.remove();
        --this.size;
        return defaultHeaders$HeaderEntry2;
    }

    private T thisT() {
        return (T)this;
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> defaultHeaders = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        defaultHeaders.addImpl(this);
        return defaultHeaders;
    }

    static /* synthetic */ HashingStrategy access$100(DefaultHeaders defaultHeaders) {
        return defaultHeaders.hashingStrategy;
    }

    static /* synthetic */ DefaultHeaders$HeaderEntry[] access$200(DefaultHeaders defaultHeaders) {
        return defaultHeaders.entries;
    }

    static /* synthetic */ int access$300(DefaultHeaders defaultHeaders, int n4) {
        return defaultHeaders.index(n4);
    }

    static /* synthetic */ DefaultHeaders$HeaderEntry access$400(DefaultHeaders defaultHeaders, DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry, DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry2) {
        return defaultHeaders.remove0(defaultHeaders$HeaderEntry, defaultHeaders$HeaderEntry2);
    }
}

