/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.handler.codec.DateFormatter$1;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateFormatter {
    private static final BitSet DELIMITERS;
    private static final String[] DAY_OF_WEEK_TO_SHORT_NAME;
    private static final String[] CALENDAR_MONTH_TO_SHORT_NAME;
    private static final FastThreadLocal<DateFormatter> INSTANCES;
    private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final StringBuilder sb = new StringBuilder(29);
    private boolean timeFound;
    private int hours;
    private int minutes;
    private int seconds;
    private boolean dayOfMonthFound;
    private int dayOfMonth;
    private boolean monthFound;
    private int month;
    private boolean yearFound;
    private int year;

    public static Date parseHttpDate(CharSequence charSequence) {
        return DateFormatter.parseHttpDate(charSequence, 0, charSequence.length());
    }

    public static Date parseHttpDate(CharSequence charSequence, int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 == 0) {
            return null;
        }
        if (n8 < 0) {
            throw new IllegalArgumentException("Can't have end < start");
        }
        if (n8 > 64) {
            throw new IllegalArgumentException("Can't parse more than 64 chars,looks like a user error or a malformed header");
        }
        return DateFormatter.formatter().parse0(ObjectUtil.checkNotNull(charSequence, "txt"), n4, n7);
    }

    public static String format(Date date) {
        return DateFormatter.formatter().format0(ObjectUtil.checkNotNull(date, "date"));
    }

    public static StringBuilder append(Date date, StringBuilder stringBuilder) {
        return DateFormatter.formatter().append0(ObjectUtil.checkNotNull(date, "date"), ObjectUtil.checkNotNull(stringBuilder, "sb"));
    }

    private static DateFormatter formatter() {
        DateFormatter dateFormatter = INSTANCES.get();
        dateFormatter.reset();
        return dateFormatter;
    }

    private static boolean isDelim(char c10) {
        return DELIMITERS.get(c10);
    }

    private static boolean isDigit(char c10) {
        return c10 >= '0' && c10 <= '9';
    }

    private static int getNumericalValue(char c10) {
        return c10 - 48;
    }

    private DateFormatter() {
        this.reset();
    }

    public void reset() {
        this.timeFound = false;
        this.hours = -1;
        this.minutes = -1;
        this.seconds = -1;
        this.dayOfMonthFound = false;
        this.dayOfMonth = -1;
        this.monthFound = false;
        this.month = -1;
        this.yearFound = false;
        this.year = -1;
        this.cal.clear();
        this.sb.setLength(0);
    }

    private boolean tryParseTime(CharSequence charSequence, int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 < 5 || n8 > 8) {
            return false;
        }
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        for (int i3 = n4; i3 < n7; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (DateFormatter.isDigit(c10)) {
                n14 = n14 * 10 + DateFormatter.getNumericalValue(c10);
                if (++n15 <= 2) continue;
                return false;
            }
            if (c10 == ':') {
                if (n15 == 0) {
                    return false;
                }
                switch (n13) {
                    case 0: {
                        n10 = n14;
                        break;
                    }
                    case 1: {
                        n11 = n14;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                n14 = 0;
                ++n13;
                n15 = 0;
                continue;
            }
            return false;
        }
        if (n15 > 0) {
            n12 = n14;
        }
        if (n10 >= 0 && n11 >= 0 && n12 >= 0) {
            this.hours = n10;
            this.minutes = n11;
            this.seconds = n12;
            return true;
        }
        return false;
    }

    private boolean tryParseDayOfMonth(CharSequence charSequence, int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 == 1) {
            char c10 = charSequence.charAt(n4);
            if (DateFormatter.isDigit(c10)) {
                this.dayOfMonth = DateFormatter.getNumericalValue(c10);
                return true;
            }
        } else if (n8 == 2) {
            char c11 = charSequence.charAt(n4);
            char c12 = charSequence.charAt(n4 + 1);
            if (DateFormatter.isDigit(c11) && DateFormatter.isDigit(c12)) {
                this.dayOfMonth = DateFormatter.getNumericalValue(c11) * 10 + DateFormatter.getNumericalValue(c12);
                return true;
            }
        }
        return false;
    }

    private boolean tryParseMonth(CharSequence charSequence, int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 != 3) {
            return false;
        }
        char c10 = AsciiString.toLowerCase(charSequence.charAt(n4));
        char c11 = AsciiString.toLowerCase(charSequence.charAt(n4 + 1));
        char c12 = AsciiString.toLowerCase(charSequence.charAt(n4 + 2));
        if (c10 == 'j' && c11 == 'a' && c12 == 'n') {
            this.month = 0;
        } else if (c10 == 'f' && c11 == 'e' && c12 == 'b') {
            this.month = 1;
        } else if (c10 == 'm' && c11 == 'a' && c12 == 'r') {
            this.month = 2;
        } else if (c10 == 'a' && c11 == 'p' && c12 == 'r') {
            this.month = 3;
        } else if (c10 == 'm' && c11 == 'a' && c12 == 'y') {
            this.month = 4;
        } else if (c10 == 'j' && c11 == 'u' && c12 == 'n') {
            this.month = 5;
        } else if (c10 == 'j' && c11 == 'u' && c12 == 'l') {
            this.month = 6;
        } else if (c10 == 'a' && c11 == 'u' && c12 == 'g') {
            this.month = 7;
        } else if (c10 == 's' && c11 == 'e' && c12 == 'p') {
            this.month = 8;
        } else if (c10 == 'o' && c11 == 'c' && c12 == 't') {
            this.month = 9;
        } else if (c10 == 'n' && c11 == 'o' && c12 == 'v') {
            this.month = 10;
        } else if (c10 == 'd' && c11 == 'e' && c12 == 'c') {
            this.month = 11;
        } else {
            return false;
        }
        return true;
    }

    private boolean tryParseYear(CharSequence charSequence, int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 == 2) {
            char c10 = charSequence.charAt(n4);
            char c11 = charSequence.charAt(n4 + 1);
            if (DateFormatter.isDigit(c10) && DateFormatter.isDigit(c11)) {
                this.year = DateFormatter.getNumericalValue(c10) * 10 + DateFormatter.getNumericalValue(c11);
                return true;
            }
        } else if (n8 == 4) {
            char c12 = charSequence.charAt(n4);
            char c13 = charSequence.charAt(n4 + 1);
            char c14 = charSequence.charAt(n4 + 2);
            char c15 = charSequence.charAt(n4 + 3);
            if (DateFormatter.isDigit(c12) && DateFormatter.isDigit(c13) && DateFormatter.isDigit(c14) && DateFormatter.isDigit(c15)) {
                this.year = DateFormatter.getNumericalValue(c12) * 1000 + DateFormatter.getNumericalValue(c13) * 100 + DateFormatter.getNumericalValue(c14) * 10 + DateFormatter.getNumericalValue(c15);
                return true;
            }
        }
        return false;
    }

    private boolean parseToken(CharSequence charSequence, int n4, int n7) {
        if (!this.timeFound) {
            this.timeFound = this.tryParseTime(charSequence, n4, n7);
            if (this.timeFound) {
                return this.dayOfMonthFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.dayOfMonthFound) {
            this.dayOfMonthFound = this.tryParseDayOfMonth(charSequence, n4, n7);
            if (this.dayOfMonthFound) {
                return this.timeFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.monthFound) {
            this.monthFound = this.tryParseMonth(charSequence, n4, n7);
            if (this.monthFound) {
                return this.timeFound && this.dayOfMonthFound && this.yearFound;
            }
        }
        if (!this.yearFound) {
            this.yearFound = this.tryParseYear(charSequence, n4, n7);
        }
        return this.timeFound && this.dayOfMonthFound && this.monthFound && this.yearFound;
    }

    private Date parse0(CharSequence charSequence, int n4, int n7) {
        boolean bl3 = this.parse1(charSequence, n4, n7);
        return bl3 && this.normalizeAndValidate() ? this.computeDate() : null;
    }

    private boolean parse1(CharSequence charSequence, int n4, int n7) {
        int n8 = -1;
        for (int i3 = n4; i3 < n7; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (DateFormatter.isDelim(c10)) {
                if (n8 == -1) continue;
                if (this.parseToken(charSequence, n8, i3)) {
                    return true;
                }
                n8 = -1;
                continue;
            }
            if (n8 != -1) continue;
            n8 = i3;
        }
        return n8 != -1 && this.parseToken(charSequence, n8, charSequence.length());
    }

    private boolean normalizeAndValidate() {
        if (this.dayOfMonth < 1 || this.dayOfMonth > 31 || this.hours > 23 || this.minutes > 59 || this.seconds > 59) {
            return false;
        }
        if (this.year >= 70 && this.year <= 99) {
            this.year += 1900;
        } else if (this.year >= 0 && this.year < 70) {
            this.year += 2000;
        } else if (this.year < 1601) {
            return false;
        }
        return true;
    }

    private Date computeDate() {
        this.cal.set(5, this.dayOfMonth);
        this.cal.set(2, this.month);
        this.cal.set(1, this.year);
        this.cal.set(11, this.hours);
        this.cal.set(12, this.minutes);
        this.cal.set(13, this.seconds);
        return this.cal.getTime();
    }

    private String format0(Date date) {
        this.append0(date, this.sb);
        return this.sb.toString();
    }

    private StringBuilder append0(Date date, StringBuilder stringBuilder) {
        this.cal.setTime(date);
        stringBuilder.append(DAY_OF_WEEK_TO_SHORT_NAME[this.cal.get(7) - 1]).append(", ");
        stringBuilder.append(this.cal.get(5)).append(' ');
        stringBuilder.append(CALENDAR_MONTH_TO_SHORT_NAME[this.cal.get(2)]).append(' ');
        stringBuilder.append(this.cal.get(1)).append(' ');
        DateFormatter.appendZeroLeftPadded(this.cal.get(11), stringBuilder).append(':');
        DateFormatter.appendZeroLeftPadded(this.cal.get(12), stringBuilder).append(':');
        return DateFormatter.appendZeroLeftPadded(this.cal.get(13), stringBuilder).append(" GMT");
    }

    private static StringBuilder appendZeroLeftPadded(int n4, StringBuilder stringBuilder) {
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(n4);
    }

    /* synthetic */ DateFormatter(DateFormatter$1 dateFormatter$1) {
        this();
    }

    static {
        int n4;
        DELIMITERS = new BitSet();
        DELIMITERS.set(9);
        for (n4 = 32; n4 <= 47; n4 = (int)((char)(n4 + 1))) {
            DELIMITERS.set(n4);
        }
        for (n4 = 59; n4 <= 64; n4 = (int)((char)(n4 + 1))) {
            DELIMITERS.set(n4);
        }
        for (n4 = 91; n4 <= 96; n4 = (int)((char)(n4 + 1))) {
            DELIMITERS.set(n4);
        }
        for (n4 = 123; n4 <= 126; n4 = (int)((char)(n4 + 1))) {
            DELIMITERS.set(n4);
        }
        DAY_OF_WEEK_TO_SHORT_NAME = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        CALENDAR_MONTH_TO_SHORT_NAME = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        INSTANCES = new DateFormatter$1();
    }
}

