/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.socket.DatagramPacket;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public class DatagramPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final MessageToMessageDecoder<ByteBuf> decoder;

    public DatagramPacketDecoder(MessageToMessageDecoder<ByteBuf> messageToMessageDecoder) {
        this.decoder = ObjectUtil.checkNotNull(messageToMessageDecoder, "decoder");
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        if (object instanceof DatagramPacket) {
            return this.decoder.acceptInboundMessage(((DatagramPacket)object).content());
        }
        return false;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket datagramPacket, List<Object> list) {
        this.decoder.decode(channelHandlerContext, (ByteBuf)datagramPacket.content(), list);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelRegistered(channelHandlerContext);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelUnregistered(channelHandlerContext);
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelInactive(channelHandlerContext);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelReadComplete(channelHandlerContext);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        this.decoder.userEventTriggered(channelHandlerContext, object);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelWritabilityChanged(channelHandlerContext);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.decoder.exceptionCaught(channelHandlerContext, throwable);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.decoder.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.decoder.handlerRemoved(channelHandlerContext);
    }

    @Override
    public boolean isSharable() {
        return this.decoder.isSharable();
    }
}

