/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList$1;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList$2;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList$CodecOutputListRecycler;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList$CodecOutputLists;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputList$CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputList$1();
    private static final FastThreadLocal<CodecOutputList$CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new CodecOutputList$2();
    private final CodecOutputList$CodecOutputListRecycler recycler;
    private int size;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return CODEC_OUTPUT_LISTS_POOL.get().getOrCreate();
    }

    private CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n4) {
        this.recycler = codecOutputList$CodecOutputListRecycler;
        this.array = new Object[n4];
    }

    @Override
    public Object get(int n4) {
        this.checkIndex(n4);
        return this.array[n4];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            this.insert(this.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            this.insert(this.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public Object set(int n4, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n4);
        Object object2 = this.array[n4];
        this.insert(n4, object);
        return object2;
    }

    @Override
    public void add(int n4, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n4);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n4 != this.size) {
            System.arraycopy(this.array, n4, this.array, n4 + 1, this.size - n4);
        }
        this.insert(n4, object);
        ++this.size;
    }

    @Override
    public Object remove(int n4) {
        this.checkIndex(n4);
        Object object = this.array[n4];
        int n7 = this.size - n4 - 1;
        if (n7 > 0) {
            System.arraycopy(this.array, n4 + 1, this.array, n4, n7);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    void recycle() {
        for (int i3 = 0; i3 < this.size; ++i3) {
            this.array[i3] = null;
        }
        this.size = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    Object getUnsafe(int n4) {
        return this.array[n4];
    }

    private void checkIndex(int n4) {
        if (n4 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void insert(int n4, Object object) {
        this.array[n4] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n4 = this.array.length << 1;
        if (n4 < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n4];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    /* synthetic */ CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n4, CodecOutputList$1 codecOutputList$1) {
        this(codecOutputList$CodecOutputListRecycler, n4);
    }

    static /* synthetic */ CodecOutputList$CodecOutputListRecycler access$100() {
        return NOOP_RECYCLER;
    }
}

