/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.handler.codec.DateFormatter;
import io.grpc.netty.shaded.io.netty.handler.codec.ValueConverter;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.text.ParseException;
import java.util.Date;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();
    private static final AsciiString TRUE_ASCII = new AsciiString("true");

    @Override
    public CharSequence convertObject(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return object.toString();
    }

    @Override
    public CharSequence convertInt(int n4) {
        return String.valueOf(n4);
    }

    @Override
    public CharSequence convertLong(long l2) {
        return String.valueOf(l2);
    }

    @Override
    public CharSequence convertDouble(double d8) {
        return String.valueOf(d8);
    }

    @Override
    public CharSequence convertChar(char c10) {
        return String.valueOf(c10);
    }

    @Override
    public CharSequence convertBoolean(boolean bl3) {
        return String.valueOf(bl3);
    }

    @Override
    public CharSequence convertFloat(float f8) {
        return String.valueOf(f8);
    }

    @Override
    public boolean convertToBoolean(CharSequence charSequence) {
        return AsciiString.contentEqualsIgnoreCase(charSequence, TRUE_ASCII);
    }

    @Override
    public CharSequence convertByte(byte by2) {
        return String.valueOf(by2);
    }

    @Override
    public byte convertToByte(CharSequence charSequence) {
        if (charSequence instanceof AsciiString && charSequence.length() == 1) {
            return ((AsciiString)charSequence).byteAt(0);
        }
        return Byte.parseByte(charSequence.toString());
    }

    @Override
    public char convertToChar(CharSequence charSequence) {
        return charSequence.charAt(0);
    }

    @Override
    public CharSequence convertShort(short s11) {
        return String.valueOf(s11);
    }

    @Override
    public short convertToShort(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseShort();
        }
        return Short.parseShort(charSequence.toString());
    }

    @Override
    public int convertToInt(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseInt();
        }
        return Integer.parseInt(charSequence.toString());
    }

    @Override
    public long convertToLong(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseLong();
        }
        return Long.parseLong(charSequence.toString());
    }

    @Override
    public CharSequence convertTimeMillis(long l2) {
        return DateFormatter.format(new Date(l2));
    }

    @Override
    public long convertToTimeMillis(CharSequence charSequence) {
        Date date = DateFormatter.parseHttpDate(charSequence);
        if (date == null) {
            PlatformDependent.throwException(new ParseException("header can't be parsed into a Date: " + charSequence, 0));
            return 0L;
        }
        return date.getTime();
    }

    @Override
    public float convertToFloat(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseFloat();
        }
        return Float.parseFloat(charSequence.toString());
    }

    @Override
    public double convertToDouble(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseDouble();
        }
        return Double.parseDouble(charSequence.toString());
    }
}

