/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder$2;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder$Cumulator;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecOutputList;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final ByteToMessageDecoder$Cumulator MERGE_CUMULATOR = new ByteToMessageDecoder$1();
    public static final ByteToMessageDecoder$Cumulator COMPOSITE_CUMULATOR = new ByteToMessageDecoder$2();
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    ByteBuf cumulation;
    private ByteToMessageDecoder$Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    public void setSingleDecode(boolean bl3) {
        this.singleDecode = bl3;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(ByteToMessageDecoder$Cumulator byteToMessageDecoder$Cumulator) {
        if (byteToMessageDecoder$Cumulator == null) {
            throw new NullPointerException("cumulator");
        }
        this.cumulator = byteToMessageDecoder$Cumulator;
    }

    public void setDiscardAfterReads(int n4) {
        ObjectUtil.checkPositive(n4, "discardAfterReads");
        this.discardAfterReads = n4;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int n4 = byteBuf.readableBytes();
            if (n4 > 0) {
                ByteBuf byteBuf2 = byteBuf.readBytes(n4);
                byteBuf.release();
                channelHandlerContext.fireChannelRead(byteBuf2);
                channelHandlerContext.fireChannelReadComplete();
            } else {
                byteBuf.release();
            }
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ByteBuf) {
            CodecOutputList codecOutputList = CodecOutputList.newInstance();
            try {
                ByteBuf byteBuf = (ByteBuf)object;
                this.first = this.cumulation == null;
                this.cumulation = this.first ? byteBuf : this.cumulator.cumulate(channelHandlerContext.alloc(), this.cumulation, byteBuf);
                this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
            }
            catch (DecoderException decoderException) {
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
            finally {
                if (this.cumulation != null && !this.cumulation.isReadable()) {
                    this.numReads = 0;
                    this.cumulation.release();
                    this.cumulation = null;
                } else if (++this.numReads >= this.discardAfterReads) {
                    this.numReads = 0;
                    this.discardSomeReadBytes();
                }
                int n4 = codecOutputList.size();
                this.firedChannelRead |= codecOutputList.insertSinceRecycled();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n4);
                codecOutputList.recycle();
            }
        } else {
            channelHandlerContext.fireChannelRead(object);
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n4) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n4);
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                channelHandlerContext.fireChannelRead(list.get(i3));
            }
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i3));
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (!this.firedChannelRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.channelInputClosed(channelHandlerContext, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl3) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n4 = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n4);
                if (n4 > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl3) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            this.decodeLast(channelHandlerContext, this.cumulation, list);
        } else {
            this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
        }
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            while (byteBuf.isReadable()) {
                int n4 = list.size();
                if (n4 > 0) {
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n4);
                    list.clear();
                    if (channelHandlerContext.isRemoved()) break;
                    n4 = 0;
                }
                int n7 = byteBuf.readableBytes();
                this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
                if (!channelHandlerContext.isRemoved()) {
                    if (n4 == list.size()) {
                        if (n7 != byteBuf.readableBytes()) continue;
                    } else {
                        if (n7 == byteBuf.readableBytes()) {
                            throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                        }
                        if (!this.isSingleDecode()) continue;
                    }
                }
                break;
            }
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decodeRemovalReentryProtection(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        boolean bl3;
        this.decodeState = 1;
        try {
            this.decode(channelHandlerContext, byteBuf, list);
            bl3 = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean bl4 = this.decodeState == 2;
            this.decodeState = 0;
            if (bl4) {
                this.handlerRemoved(channelHandlerContext);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (bl3) {
            this.handlerRemoved(channelHandlerContext);
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
        }
    }

    static ByteBuf expandCumulation(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n4) {
        ByteBuf byteBuf2 = byteBuf;
        byteBuf = byteBufAllocator.buffer(byteBuf2.readableBytes() + n4);
        byteBuf.writeBytes(byteBuf2);
        byteBuf2.release();
        return byteBuf;
    }
}

