/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageCodec$1;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageCodec$Encoder;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class ByteToMessageCodec<I>
extends ChannelDuplexHandler {
    private final TypeParameterMatcher outboundMsgMatcher;
    private final MessageToByteEncoder<I> encoder;
    private final ByteToMessageDecoder decoder = new ByteToMessageCodec$1(this);

    protected ByteToMessageCodec() {
        this(true);
    }

    protected ByteToMessageCodec(Class<? extends I> clazz) {
        this(clazz, true);
    }

    protected ByteToMessageCodec(boolean bl3) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.find(this, ByteToMessageCodec.class, "I");
        this.encoder = new ByteToMessageCodec$Encoder(this, bl3);
    }

    protected ByteToMessageCodec(Class<? extends I> clazz, boolean bl3) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.get(clazz);
        this.encoder = new ByteToMessageCodec$Encoder(this, bl3);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.outboundMsgMatcher.match(object);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.decoder.channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.encoder.write(channelHandlerContext, object, channelPromise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelReadComplete(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelInactive(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        try {
            this.decoder.handlerAdded(channelHandlerContext);
        }
        finally {
            this.encoder.handlerAdded(channelHandlerContext);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            this.decoder.handlerRemoved(channelHandlerContext);
        }
        finally {
            this.encoder.handlerRemoved(channelHandlerContext);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3);

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decode(channelHandlerContext, byteBuf, list);
        }
    }
}

