/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.AsciiHeadersEncoder$NewlineType;
import io.grpc.netty.shaded.io.netty.handler.codec.AsciiHeadersEncoder$SeparatorType;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.util.Map;

public final class AsciiHeadersEncoder {
    private final ByteBuf buf;
    private final AsciiHeadersEncoder$SeparatorType separatorType;
    private final AsciiHeadersEncoder$NewlineType newlineType;

    public AsciiHeadersEncoder(ByteBuf byteBuf) {
        this(byteBuf, AsciiHeadersEncoder$SeparatorType.COLON_SPACE, AsciiHeadersEncoder$NewlineType.CRLF);
    }

    public AsciiHeadersEncoder(ByteBuf byteBuf, AsciiHeadersEncoder$SeparatorType asciiHeadersEncoder$SeparatorType, AsciiHeadersEncoder$NewlineType asciiHeadersEncoder$NewlineType) {
        if (byteBuf == null) {
            throw new NullPointerException("buf");
        }
        if (asciiHeadersEncoder$SeparatorType == null) {
            throw new NullPointerException("separatorType");
        }
        if (asciiHeadersEncoder$NewlineType == null) {
            throw new NullPointerException("newlineType");
        }
        this.buf = byteBuf;
        this.separatorType = asciiHeadersEncoder$SeparatorType;
        this.newlineType = asciiHeadersEncoder$NewlineType;
    }

    public void encode(Map.Entry<CharSequence, CharSequence> entry) {
        CharSequence charSequence = entry.getKey();
        CharSequence charSequence2 = entry.getValue();
        ByteBuf byteBuf = this.buf;
        int n4 = charSequence.length();
        int n7 = charSequence2.length();
        int n8 = n4 + n7 + 4;
        int n10 = byteBuf.writerIndex();
        byteBuf.ensureWritable(n8);
        AsciiHeadersEncoder.writeAscii(byteBuf, n10, charSequence);
        n10 += n4;
        switch (this.separatorType) {
            case COLON: {
                byteBuf.setByte(n10++, 58);
                break;
            }
            case COLON_SPACE: {
                byteBuf.setByte(n10++, 58);
                byteBuf.setByte(n10++, 32);
                break;
            }
            default: {
                throw new Error();
            }
        }
        AsciiHeadersEncoder.writeAscii(byteBuf, n10, charSequence2);
        n10 += n7;
        switch (this.newlineType) {
            case LF: {
                byteBuf.setByte(n10++, 10);
                break;
            }
            case CRLF: {
                byteBuf.setByte(n10++, 13);
                byteBuf.setByte(n10++, 10);
                break;
            }
            default: {
                throw new Error();
            }
        }
        byteBuf.writerIndex(n10);
    }

    private static void writeAscii(ByteBuf byteBuf, int n4, CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)charSequence, 0, byteBuf, n4, charSequence.length());
        } else {
            byteBuf.setCharSequence(n4, charSequence, CharsetUtil.US_ASCII);
        }
    }
}

