/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    private final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fileDescriptor) {
        this.fd = ObjectUtil.checkNotNull(fileDescriptor, "fd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int write(ByteBuffer byteBuffer) {
        int n4;
        int n7 = byteBuffer.position();
        int n8 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n4 = this.fd.write(byteBuffer, n7, byteBuffer.limit());
        } else {
            int n10 = n8 - n7;
            ByteBuf byteBuf = null;
            try {
                Object object;
                if (n10 == 0) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                } else {
                    object = this.alloc();
                    if (object.isDirectBufferPooled()) {
                        byteBuf = object.directBuffer(n10);
                    } else {
                        byteBuf = ByteBufUtil.threadLocalDirectBuffer();
                        if (byteBuf == null) {
                            byteBuf = Unpooled.directBuffer(n10);
                        }
                    }
                }
                byteBuf.writeBytes(byteBuffer.duplicate());
                object = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n10);
                n4 = this.fd.write((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }
        if (n4 > 0) {
            byteBuffer.position(n7 + n4);
        }
        return n4;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() {
        this.fd.close();
    }

    protected abstract ByteBufAllocator alloc();
}

