/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.unix.DatagramSocketAddress;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.channel.unix.Errors;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.channel.unix.LimitsStaticallyReferencedJniMethods;
import io.grpc.netty.shaded.io.netty.channel.unix.NativeInetAddress;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Socket
extends FileDescriptor {
    public static final int UDS_SUN_PATH_SIZE = LimitsStaticallyReferencedJniMethods.udsSunPathSize();
    protected final boolean ipv6;
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();

    public Socket(int n4) {
        super(n4);
        this.ipv6 = Socket.isIPv6(n4);
    }

    public final void shutdown() {
        this.shutdown(true, true);
    }

    public final void shutdown(boolean bl3, boolean bl4) {
        int n4;
        int n7;
        do {
            if (Socket.isClosed(n7 = this.state)) {
                throw new ClosedChannelException();
            }
            n4 = n7;
            if (bl3 && !Socket.isInputShutdown(n4)) {
                n4 = Socket.inputShutdown(n4);
            }
            if (bl4 && !Socket.isOutputShutdown(n4)) {
                n4 = Socket.outputShutdown(n4);
            }
            if (n4 != n7) continue;
            return;
        } while (!this.casState(n7, n4));
        n7 = Socket.shutdown(this.fd, bl3, bl4);
        if (n7 < 0) {
            Errors.ioResult("shutdown", n7);
        }
    }

    public final boolean isShutdown() {
        int n4 = this.state;
        return Socket.isInputShutdown(n4) && Socket.isOutputShutdown(n4);
    }

    public final boolean isInputShutdown() {
        return Socket.isInputShutdown(this.state);
    }

    public final boolean isOutputShutdown() {
        return Socket.isOutputShutdown(this.state);
    }

    public final int sendTo(ByteBuffer byteBuffer, int n4, int n7, InetAddress inetAddress, int n8) {
        int n10;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n10 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n10 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n11 = Socket.sendTo(this.fd, this.ipv6, byteBuffer, n4, n7, byArray, n10, n8);
        if (n11 >= 0) {
            return n11;
        }
        if (n11 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendTo failed");
        }
        return Errors.ioResult("sendTo", n11);
    }

    public final int sendToAddress(long l2, int n4, int n7, InetAddress inetAddress, int n8) {
        int n10;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n10 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n10 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n11 = Socket.sendToAddress(this.fd, this.ipv6, l2, n4, n7, byArray, n10, n8);
        if (n11 >= 0) {
            return n11;
        }
        if (n11 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddress failed");
        }
        return Errors.ioResult("sendToAddress", n11);
    }

    public final int sendToAddresses(long l2, int n4, InetAddress inetAddress, int n7) {
        int n8;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n8 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n8 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n10 = Socket.sendToAddresses(this.fd, this.ipv6, l2, n4, byArray, n8, n7);
        if (n10 >= 0) {
            return n10;
        }
        if (n10 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddresses failed");
        }
        return Errors.ioResult("sendToAddresses", n10);
    }

    public final DatagramSocketAddress recvFrom(ByteBuffer byteBuffer, int n4, int n7) {
        return Socket.recvFrom(this.fd, byteBuffer, n4, n7);
    }

    public final DatagramSocketAddress recvFromAddress(long l2, int n4, int n7) {
        return Socket.recvFromAddress(this.fd, l2, n4, n7);
    }

    public final int recvFd() {
        int n4 = Socket.recvFd(this.fd);
        if (n4 > 0) {
            return n4;
        }
        if (n4 == 0) {
            return -1;
        }
        if (n4 == Errors.ERRNO_EAGAIN_NEGATIVE || n4 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", n4);
    }

    public final int sendFd(int n4) {
        int n7 = Socket.sendFd(this.fd, n4);
        if (n7 >= 0) {
            return n7;
        }
        if (n7 == Errors.ERRNO_EAGAIN_NEGATIVE || n7 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", n7);
    }

    public final boolean connect(SocketAddress socketAddress) {
        int n4;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetSocketAddress.getAddress());
            n4 = Socket.connect(this.fd, this.ipv6, nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            n4 = Socket.connectDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
        if (n4 < 0) {
            if (n4 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("connect", n4);
        }
        return true;
    }

    public final boolean finishConnect() {
        int n4 = Socket.finishConnect(this.fd);
        if (n4 < 0) {
            if (n4 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("finishConnect", n4);
        }
        return true;
    }

    public final void disconnect() {
        int n4 = Socket.disconnect(this.fd, this.ipv6);
        if (n4 < 0) {
            Errors.throwConnectException("disconnect", n4);
        }
    }

    public final void bind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetSocketAddress.getAddress());
            int n4 = Socket.bind(this.fd, this.ipv6, nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
            if (n4 < 0) {
                throw Errors.newIOException("bind", n4);
            }
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            int n7 = Socket.bindDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
            if (n7 < 0) {
                throw Errors.newIOException("bind", n7);
            }
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
    }

    public final void listen(int n4) {
        int n7 = Socket.listen(this.fd, n4);
        if (n7 < 0) {
            throw Errors.newIOException("listen", n7);
        }
    }

    public final int accept(byte[] byArray) {
        int n4 = Socket.accept(this.fd, byArray);
        if (n4 >= 0) {
            return n4;
        }
        if (n4 == Errors.ERRNO_EAGAIN_NEGATIVE || n4 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", n4);
    }

    public final InetSocketAddress remoteAddress() {
        byte[] byArray = Socket.remoteAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final InetSocketAddress localAddress() {
        byte[] byArray = Socket.localAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final int getReceiveBufferSize() {
        return Socket.getReceiveBufferSize(this.fd);
    }

    public final int getSendBufferSize() {
        return Socket.getSendBufferSize(this.fd);
    }

    public final boolean isKeepAlive() {
        return Socket.isKeepAlive(this.fd) != 0;
    }

    public final boolean isTcpNoDelay() {
        return Socket.isTcpNoDelay(this.fd) != 0;
    }

    public final boolean isReuseAddress() {
        return Socket.isReuseAddress(this.fd) != 0;
    }

    public final boolean isReusePort() {
        return Socket.isReusePort(this.fd) != 0;
    }

    public final boolean isBroadcast() {
        return Socket.isBroadcast(this.fd) != 0;
    }

    public final int getSoLinger() {
        return Socket.getSoLinger(this.fd);
    }

    public final int getSoError() {
        return Socket.getSoError(this.fd);
    }

    public final int getTrafficClass() {
        return Socket.getTrafficClass(this.fd, this.ipv6);
    }

    public final void setKeepAlive(boolean bl3) {
        Socket.setKeepAlive(this.fd, bl3 ? 1 : 0);
    }

    public final void setReceiveBufferSize(int n4) {
        Socket.setReceiveBufferSize(this.fd, n4);
    }

    public final void setSendBufferSize(int n4) {
        Socket.setSendBufferSize(this.fd, n4);
    }

    public final void setTcpNoDelay(boolean bl3) {
        Socket.setTcpNoDelay(this.fd, bl3 ? 1 : 0);
    }

    public final void setSoLinger(int n4) {
        Socket.setSoLinger(this.fd, n4);
    }

    public final void setReuseAddress(boolean bl3) {
        Socket.setReuseAddress(this.fd, bl3 ? 1 : 0);
    }

    public final void setReusePort(boolean bl3) {
        Socket.setReusePort(this.fd, bl3 ? 1 : 0);
    }

    public final void setBroadcast(boolean bl3) {
        Socket.setBroadcast(this.fd, bl3 ? 1 : 0);
    }

    public final void setTrafficClass(int n4) {
        Socket.setTrafficClass(this.fd, this.ipv6, n4);
    }

    public static native boolean isIPv6Preferred();

    private static native boolean isIPv6(int var0);

    @Override
    public String toString() {
        return "Socket{fd=" + this.fd + '}';
    }

    public static Socket newSocketStream() {
        return new Socket(Socket.newSocketStream0());
    }

    public static Socket newSocketDgram() {
        return new Socket(Socket.newSocketDgram0());
    }

    public static Socket newSocketDomain() {
        return new Socket(Socket.newSocketDomain0());
    }

    public static void initialize() {
        if (INITIALIZED.compareAndSet(false, true)) {
            Socket.initialize(NetUtil.isIpV4StackPreferred());
        }
    }

    protected static int newSocketStream0() {
        return Socket.newSocketStream0(Socket.isIPv6Preferred());
    }

    public static int newSocketStream0(boolean bl3) {
        int n4 = Socket.newSocketStreamFd(bl3);
        if (n4 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketStream", n4));
        }
        return n4;
    }

    protected static int newSocketDgram0() {
        return Socket.newSocketDgram0(Socket.isIPv6Preferred());
    }

    public static int newSocketDgram0(boolean bl3) {
        int n4 = Socket.newSocketDgramFd(bl3);
        if (n4 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDgram", n4));
        }
        return n4;
    }

    public static int newSocketDomain0() {
        int n4 = Socket.newSocketDomainFd();
        if (n4 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDomain", n4));
        }
        return n4;
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int disconnect(int var0, boolean var1);

    private static native int bind(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native int sendTo(int var0, boolean var1, ByteBuffer var2, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int sendToAddress(int var0, boolean var1, long var2, int var4, int var5, byte[] var6, int var7, int var8);

    private static native int sendToAddresses(int var0, boolean var1, long var2, int var4, byte[] var5, int var6, int var7);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3);

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4);

    private static native int recvFd(int var0);

    private static native int sendFd(int var0, int var1);

    private static native int newSocketStreamFd(boolean var0);

    private static native int newSocketDgramFd(boolean var0);

    private static native int newSocketDomainFd();

    private static native int isReuseAddress(int var0);

    private static native int isReusePort(int var0);

    private static native int getReceiveBufferSize(int var0);

    private static native int getSendBufferSize(int var0);

    private static native int isKeepAlive(int var0);

    private static native int isTcpNoDelay(int var0);

    private static native int isBroadcast(int var0);

    private static native int getSoLinger(int var0);

    private static native int getSoError(int var0);

    private static native int getTrafficClass(int var0, boolean var1);

    private static native void setReuseAddress(int var0, int var1);

    private static native void setReusePort(int var0, int var1);

    private static native void setKeepAlive(int var0, int var1);

    private static native void setReceiveBufferSize(int var0, int var1);

    private static native void setSendBufferSize(int var0, int var1);

    private static native void setTcpNoDelay(int var0, int var1);

    private static native void setSoLinger(int var0, int var1);

    private static native void setBroadcast(int var0, int var1);

    private static native void setTrafficClass(int var0, boolean var1, int var2);

    private static native void initialize(boolean var0);
}

