/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class NativeInetAddress {
    private static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    final byte[] address;
    final int scopeId;

    public static NativeInetAddress newInstance(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (inetAddress instanceof Inet6Address) {
            return new NativeInetAddress(byArray, ((Inet6Address)inetAddress).getScopeId());
        }
        return new NativeInetAddress(NativeInetAddress.ipv4MappedIpv6Address(byArray));
    }

    public NativeInetAddress(byte[] byArray, int n4) {
        this.address = byArray;
        this.scopeId = n4;
    }

    public NativeInetAddress(byte[] byArray) {
        this(byArray, 0);
    }

    public byte[] address() {
        return this.address;
    }

    public int scopeId() {
        return this.scopeId;
    }

    public static byte[] ipv4MappedIpv6Address(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        System.arraycopy(IPV4_MAPPED_IPV6_PREFIX, 0, byArray2, 0, IPV4_MAPPED_IPV6_PREFIX.length);
        System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
        return byArray2;
    }

    public static InetSocketAddress address(byte[] byArray, int n4, int n7) {
        int n8 = NativeInetAddress.decodeInt(byArray, n4 + n7 - 4);
        try {
            InetAddress inetAddress;
            switch (n7) {
                case 8: {
                    byte[] byArray2 = new byte[4];
                    System.arraycopy(byArray, n4, byArray2, 0, 4);
                    inetAddress = InetAddress.getByAddress(byArray2);
                    break;
                }
                case 24: {
                    byte[] byArray3 = new byte[16];
                    System.arraycopy(byArray, n4, byArray3, 0, 16);
                    int n10 = NativeInetAddress.decodeInt(byArray, n4 + n7 - 8);
                    inetAddress = Inet6Address.getByAddress(null, byArray3, n10);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return new InetSocketAddress(inetAddress, n8);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Error("Should never happen", unknownHostException);
        }
    }

    static int decodeInt(byte[] byArray, int n4) {
        return (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
    }
}

