/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.grpc.netty.shaded.io.netty.channel.unix.Buffer;
import io.grpc.netty.shaded.io.netty.channel.unix.Limits;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class IovArray
implements ChannelOutboundBuffer$MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final ByteBuffer memory;
    private final long memoryAddress;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this.memory = Buffer.allocateDirectWithNativeOrder(CAPACITY);
        this.memoryAddress = Buffer.memoryAddress(this.memory);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    public boolean add(ByteBuf byteBuf) {
        ByteBuffer[] byteBufferArray;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (byteBuf.nioBufferCount() == 1) {
            int n4 = byteBuf.readableBytes();
            if (n4 == 0) {
                return true;
            }
            if (byteBuf.hasMemoryAddress()) {
                return this.add(byteBuf.memoryAddress(), byteBuf.readerIndex(), n4);
            }
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n4);
            return this.add(Buffer.memoryAddress(byteBuffer), byteBuffer.position(), n4);
        }
        for (ByteBuffer byteBuffer : byteBufferArray = byteBuf.nioBuffers()) {
            int n7 = byteBuffer.remaining();
            if (n7 == 0 || this.add(Buffer.memoryAddress(byteBuffer), byteBuffer.position(), n7) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long l2, int n4, int n7) {
        assert (l2 != 0L);
        if (this.maxBytes - (long)n7 < this.size && this.count > 0) {
            return false;
        }
        int n8 = IovArray.idx(this.count);
        int n10 = n8 + ADDRESS_SIZE;
        this.size += (long)n7;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)n8 + this.memoryAddress, l2 + (long)n4);
                PlatformDependent.putLong((long)n10 + this.memoryAddress, n7);
            } else {
                this.memory.putLong(n8, l2 + (long)n4);
                this.memory.putLong(n10, n7);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)n8 + this.memoryAddress, (int)l2 + n4);
                PlatformDependent.putInt((long)n10 + this.memoryAddress, n7);
            } else {
                this.memory.putInt(n8, (int)l2 + n4);
                this.memory.putInt(n10, n7);
            }
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long l2) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive(l2, "maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int n4) {
        return this.memoryAddress + (long)IovArray.idx(n4);
    }

    public void release() {
        Buffer.free(this.memory);
    }

    @Override
    public boolean processMessage(Object object) {
        return object instanceof ByteBuf && this.add((ByteBuf)object);
    }

    private static int idx(int n4) {
        return IOV_SIZE * n4;
    }
}

