/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.channel.unix.Errors;
import io.grpc.netty.shaded.io.netty.channel.unix.Limits;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class FileDescriptor {
    private static final AtomicIntegerFieldUpdater<FileDescriptor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(FileDescriptor.class, "state");
    private static final int STATE_CLOSED_MASK = 1;
    private static final int STATE_INPUT_SHUTDOWN_MASK = 2;
    private static final int STATE_OUTPUT_SHUTDOWN_MASK = 4;
    private static final int STATE_ALL_MASK = 7;
    volatile int state;
    final int fd;

    public FileDescriptor(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "fd");
        this.fd = n4;
    }

    public final int intValue() {
        return this.fd;
    }

    public void close() {
        int n4;
        do {
            if (!FileDescriptor.isClosed(n4 = this.state)) continue;
            return;
        } while (!this.casState(n4, n4 | 7));
        n4 = FileDescriptor.close(this.fd);
        if (n4 < 0) {
            throw Errors.newIOException("close", n4);
        }
    }

    public boolean isOpen() {
        return !FileDescriptor.isClosed(this.state);
    }

    public final int write(ByteBuffer byteBuffer, int n4, int n7) {
        int n8 = FileDescriptor.write(this.fd, byteBuffer, n4, n7);
        if (n8 >= 0) {
            return n8;
        }
        return Errors.ioResult("write", n8);
    }

    public final int writeAddress(long l2, int n4, int n7) {
        int n8 = FileDescriptor.writeAddress(this.fd, l2, n4, n7);
        if (n8 >= 0) {
            return n8;
        }
        return Errors.ioResult("writeAddress", n8);
    }

    public final long writev(ByteBuffer[] byteBufferArray, int n4, int n7, long l2) {
        long l10 = FileDescriptor.writev(this.fd, byteBufferArray, n4, Math.min(Limits.IOV_MAX, n7), l2);
        if (l10 >= 0L) {
            return l10;
        }
        return Errors.ioResult("writev", (int)l10);
    }

    public final long writevAddresses(long l2, int n4) {
        long l10 = FileDescriptor.writevAddresses(this.fd, l2, n4);
        if (l10 >= 0L) {
            return l10;
        }
        return Errors.ioResult("writevAddresses", (int)l10);
    }

    public final int read(ByteBuffer byteBuffer, int n4, int n7) {
        int n8 = FileDescriptor.read(this.fd, byteBuffer, n4, n7);
        if (n8 > 0) {
            return n8;
        }
        if (n8 == 0) {
            return -1;
        }
        return Errors.ioResult("read", n8);
    }

    public final int readAddress(long l2, int n4, int n7) {
        int n8 = FileDescriptor.readAddress(this.fd, l2, n4, n7);
        if (n8 > 0) {
            return n8;
        }
        if (n8 == 0) {
            return -1;
        }
        return Errors.ioResult("readAddress", n8);
    }

    public String toString() {
        return "FileDescriptor{fd=" + this.fd + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileDescriptor)) {
            return false;
        }
        return this.fd == ((FileDescriptor)object).fd;
    }

    public int hashCode() {
        return this.fd;
    }

    public static FileDescriptor from(String string) {
        ObjectUtil.checkNotNull(string, "path");
        int n4 = FileDescriptor.open(string);
        if (n4 < 0) {
            throw Errors.newIOException("open", n4);
        }
        return new FileDescriptor(n4);
    }

    public static FileDescriptor from(File file) {
        return FileDescriptor.from(ObjectUtil.checkNotNull(file, "file").getPath());
    }

    public static FileDescriptor[] pipe() {
        long l2 = FileDescriptor.newPipe();
        if (l2 < 0L) {
            throw Errors.newIOException("newPipe", (int)l2);
        }
        return new FileDescriptor[]{new FileDescriptor((int)(l2 >>> 32)), new FileDescriptor((int)l2)};
    }

    final boolean casState(int n4, int n7) {
        return stateUpdater.compareAndSet(this, n4, n7);
    }

    static boolean isClosed(int n4) {
        return (n4 & 1) != 0;
    }

    static boolean isInputShutdown(int n4) {
        return (n4 & 2) != 0;
    }

    static boolean isOutputShutdown(int n4) {
        return (n4 & 4) != 0;
    }

    static int inputShutdown(int n4) {
        return n4 | 2;
    }

    static int outputShutdown(int n4) {
        return n4 | 4;
    }

    private static native int open(String var0);

    private static native int close(int var0);

    private static native int write(int var0, ByteBuffer var1, int var2, int var3);

    private static native int writeAddress(int var0, long var1, int var3, int var4);

    private static native long writev(int var0, ByteBuffer[] var1, int var2, int var3, long var4);

    private static native long writevAddresses(int var0, long var1, int var3);

    private static native int read(int var0, ByteBuffer var1, int var2, int var3);

    private static native int readAddress(int var0, long var1, int var3, int var4);

    private static native long newPipe();
}

