/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.channel.unix.Errors$NativeIoException;
import io.grpc.netty.shaded.io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;

public final class Errors {
    public static final int ERRNO_ENOENT_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOENT();
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    public static final int ERROR_EISCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEISCONN();
    public static final int ERROR_EALREADY_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEALREADY();
    public static final int ERROR_ENETUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorENETUNREACH();
    private static final String[] ERRORS = new String[512];

    static void throwConnectException(String string, int n4) {
        if (n4 == ERROR_EALREADY_NEGATIVE) {
            throw new ConnectionPendingException();
        }
        if (n4 == ERROR_ENETUNREACH_NEGATIVE) {
            throw new NoRouteToHostException();
        }
        if (n4 == ERROR_EISCONN_NEGATIVE) {
            throw new AlreadyConnectedException();
        }
        if (n4 == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw new ConnectException(string + "(..) failed: " + ERRORS[-n4]);
    }

    public static Errors$NativeIoException newConnectionResetException(String string, int n4) {
        Errors$NativeIoException errors$NativeIoException = new Errors$NativeIoException(string, n4, false);
        errors$NativeIoException.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return errors$NativeIoException;
    }

    public static Errors$NativeIoException newIOException(String string, int n4) {
        return new Errors$NativeIoException(string, n4);
    }

    @Deprecated
    public static int ioResult(String string, int n4, Errors$NativeIoException errors$NativeIoException, ClosedChannelException closedChannelException) {
        if (n4 == ERRNO_EAGAIN_NEGATIVE || n4 == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n4 == errors$NativeIoException.expectedErr()) {
            throw errors$NativeIoException;
        }
        if (n4 == ERRNO_EBADF_NEGATIVE) {
            throw closedChannelException;
        }
        if (n4 == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (n4 == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw Errors.newIOException(string, n4);
    }

    public static int ioResult(String string, int n4) {
        if (n4 == ERRNO_EAGAIN_NEGATIVE || n4 == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n4 == ERRNO_EBADF_NEGATIVE) {
            throw new ClosedChannelException();
        }
        if (n4 == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (n4 == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw new Errors$NativeIoException(string, n4, false);
    }

    private Errors() {
    }

    static /* synthetic */ String[] access$000() {
        return ERRORS;
    }

    static {
        for (int i3 = 0; i3 < ERRORS.length; ++i3) {
            Errors.ERRORS[i3] = ErrorsStaticallyReferencedJniMethods.strError(i3);
        }
    }
}

