/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.socket.oio;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.ConnectTimeoutException;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.oio.OioByteStreamChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.ServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.DefaultOioSocketChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.OioSocketChannel$1;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.OioSocketChannel$2;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.OioSocketChannel$3;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.OioSocketChannel$4;
import io.grpc.netty.shaded.io.netty.channel.socket.oio.OioSocketChannelConfig;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

@Deprecated
public class OioSocketChannel
extends OioByteStreamChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSocketChannel.class);
    private final Socket socket;
    private final OioSocketChannelConfig config;

    public OioSocketChannel() {
        this(new Socket());
    }

    public OioSocketChannel(Socket socket) {
        this(null, socket);
    }

    public OioSocketChannel(Channel channel, Socket socket) {
        super(channel);
        this.socket = socket;
        this.config = new DefaultOioSocketChannelConfig(this, socket);
        boolean bl3 = false;
        try {
            if (socket.isConnected()) {
                this.activate(socket.getInputStream(), socket.getOutputStream());
            }
            socket.setSoTimeout(1000);
            bl3 = true;
        }
        catch (Exception exception) {
            throw new ChannelException("failed to initialize a socket", exception);
        }
        finally {
            if (!bl3) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close a socket.", iOException);
                }
            }
        }
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public OioSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return !this.socket.isClosed() && this.socket.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown() || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown() || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isInputShutdown() && this.socket.isOutputShutdown() || !this.isActive();
    }

    @Override
    public final void doShutdownOutput() {
        this.shutdownOutput0();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public int doReadBytes(ByteBuf byteBuf) {
        if (this.socket.isClosed()) {
            return -1;
        }
        try {
            return super.doReadBytes(byteBuf);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownOutput0(channelPromise);
        } else {
            eventLoop.execute(new OioSocketChannel$1(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.shutdownOutput0();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownOutput0() {
        this.socket.shutdownOutput();
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            eventLoop.execute(new OioSocketChannel$2(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdownInput();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new OioSocketChannel$3(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutputDone(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            OioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new OioSocketChannel$4(this, channelFuture, channelPromise));
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        SocketUtils.bind(this.socket, socketAddress);
    }

    @Override
    public void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            SocketUtils.bind(this.socket, socketAddress2);
        }
        boolean bl3 = false;
        try {
            SocketUtils.connect(this.socket, socketAddress, this.config().getConnectTimeoutMillis());
            this.activate(this.socket.getInputStream(), this.socket.getOutputStream());
            bl3 = true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ConnectTimeoutException connectTimeoutException = new ConnectTimeoutException("connection timed out: " + socketAddress);
            connectTimeoutException.setStackTrace(socketTimeoutException.getStackTrace());
            throw connectTimeoutException;
        }
        finally {
            if (!bl3) {
                this.doClose();
            }
        }
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public void doClose() {
        this.socket.close();
    }

    protected boolean checkInputShutdown() {
        if (this.isInputShutdown()) {
            try {
                Thread.sleep(this.config().getSoTimeout());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void setReadPending(boolean bl3) {
        super.setReadPending(bl3);
    }

    final void clearReadPending0() {
        this.clearReadPending();
    }

    static /* synthetic */ void access$000(OioSocketChannel oioSocketChannel, ChannelPromise channelPromise) {
        oioSocketChannel.shutdownOutput0(channelPromise);
    }

    static /* synthetic */ void access$100(OioSocketChannel oioSocketChannel, ChannelPromise channelPromise) {
        oioSocketChannel.shutdownInput0(channelPromise);
    }

    static /* synthetic */ void access$200(OioSocketChannel oioSocketChannel, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        oioSocketChannel.shutdownOutputDone(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$300(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        OioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
    }
}

