/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.socket.nio;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator$Handle;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioByteChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop;
import io.grpc.netty.shaded.io.netty.channel.socket.ServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$1;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$2;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$3;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$4;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$NioSocketChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel$NioSocketChannelUnsafe;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openSocketChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(NioSocketChannel.newSocket(selectorProvider));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        this.config = new NioSocketChannel$NioSocketChannelConfig(this, this, socketChannel.socket(), null);
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.javaChannel().socket().isOutputShutdown() || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        Socket socket = this.javaChannel().socket();
        return socket.isInputShutdown() && socket.isOutputShutdown() || !this.isActive();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final void doShutdownOutput() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
        } else {
            this.javaChannel().socket().shutdownOutput();
        }
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            ((AbstractChannel$AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(channelPromise);
        } else {
            nioEventLoop.execute(new NioSocketChannel$1(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new NioSocketChannel$2(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new NioSocketChannel$3(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutputDone(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            NioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new NioSocketChannel$4(this, channelFuture, channelPromise));
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownInput0() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
        } else {
            this.javaChannel().socket().shutdownInput();
        }
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind(this.javaChannel(), socketAddress);
        } else {
            SocketUtils.bind(this.javaChannel().socket(), socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl3 = false;
        try {
            boolean bl4 = SocketUtils.connect(this.javaChannel(), socketAddress);
            if (!bl4) {
                this.selectionKey().interestOps(8);
            }
            bl3 = true;
            boolean bl5 = bl4;
            return bl5;
        }
        finally {
            if (!bl3) {
                this.doClose();
            }
        }
    }

    @Override
    public void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    public int doReadBytes(ByteBuf byteBuf) {
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes(this.javaChannel(), recvByteBufAllocator$Handle.attemptedBytesRead());
    }

    @Override
    public int doWriteBytes(ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n4);
    }

    @Override
    public long doWriteFileRegion(FileRegion fileRegion) {
        long l2 = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l2);
    }

    private void adjustMaxBytesPerGatheringWrite(int n4, int n7, int n8) {
        if (n4 == n7) {
            if (n4 << 1 > n8) {
                ((NioSocketChannel$NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n4 << 1);
            }
        } else if (n4 > 4096 && n7 < n4 >>> 1) {
            ((NioSocketChannel$NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n4 >>> 1);
        }
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        int n4 = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n7 = ((NioSocketChannel$NioSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n7);
            int n8 = channelOutboundBuffer.nioBufferCount();
            switch (n8) {
                case 0: {
                    n4 -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n10 = byteBuffer.remaining();
                    int n11 = socketChannel.write(byteBuffer);
                    if (n11 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n10, n11, n7);
                    channelOutboundBuffer.removeBytes(n11);
                    --n4;
                    break;
                }
                default: {
                    long l2 = channelOutboundBuffer.nioBufferSize();
                    long l10 = socketChannel.write(byteBufferArray, 0, n8);
                    if (l10 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l2, (int)l10, n7);
                    channelOutboundBuffer.removeBytes(l10);
                    --n4;
                    break;
                }
            }
        } while (n4 > 0);
        this.incompleteWrite(n4 < 0);
    }

    @Override
    public AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannel$NioSocketChannelUnsafe(this, null);
    }

    static /* synthetic */ void access$100(NioSocketChannel nioSocketChannel, ChannelPromise channelPromise) {
        nioSocketChannel.shutdownInput0(channelPromise);
    }

    static /* synthetic */ void access$200(NioSocketChannel nioSocketChannel, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        nioSocketChannel.shutdownOutputDone(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$300(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        NioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
    }

    static /* synthetic */ void access$500(NioSocketChannel nioSocketChannel) {
        nioSocketChannel.doDeregister();
    }

    static /* synthetic */ void access$600(NioSocketChannel nioSocketChannel) {
        nioSocketChannel.clearReadPending();
    }
}

