/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.oio;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator$Handle;
import io.grpc.netty.shaded.io.netty.channel.oio.AbstractOioChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    protected AbstractOioByteChannel(Channel channel) {
        super(channel);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    private void closeOnRead(ChannelPipeline channelPipeline) {
        if (this.isOpen()) {
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl3, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        recvByteBufAllocator$Handle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl3 || throwable instanceof IOException) {
            this.closeOnRead(channelPipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        ChannelConfig channelConfig = this.config();
        if (this.isInputShutdown() || !this.readPending) {
            return;
        }
        this.readPending = false;
        ChannelPipeline channelPipeline = this.pipeline();
        ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(channelConfig);
        ByteBuf byteBuf = null;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
            do {
                int n4;
                recvByteBufAllocator$Handle.lastBytesRead(this.doReadBytes(byteBuf));
                if (recvByteBufAllocator$Handle.lastBytesRead() <= 0) {
                    if (byteBuf.isReadable()) break;
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl5 = bl3 = recvByteBufAllocator$Handle.lastBytesRead() < 0;
                    if (!bl3) break;
                    this.readPending = false;
                    break;
                }
                bl4 = true;
                int n7 = this.available();
                if (n7 <= 0) break;
                if (byteBuf.isWritable()) continue;
                int n8 = byteBuf.capacity();
                if (n8 == (n4 = byteBuf.maxCapacity())) {
                    recvByteBufAllocator$Handle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
                    continue;
                }
                int n10 = byteBuf.writerIndex();
                if (n10 + n7 > n4) {
                    byteBuf.capacity(n4);
                    continue;
                }
                byteBuf.ensureWritable(n7);
            } while (recvByteBufAllocator$Handle.continueReading());
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
                byteBuf = null;
            }
            if (bl4) {
                recvByteBufAllocator$Handle.readComplete();
                channelPipeline.fireChannelReadComplete();
            }
            if (bl3) {
                this.closeOnRead(channelPipeline);
            }
        }
        catch (Throwable throwable) {
            this.handleReadException(channelPipeline, byteBuf, throwable, bl3, recvByteBufAllocator$Handle);
        }
        finally {
            if (this.readPending || channelConfig.isAutoRead() || !bl4 && this.isActive()) {
                this.read();
            }
        }
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCounted referenceCounted;
            if (object instanceof ByteBuf) {
                referenceCounted = (ByteBuf)object;
                int n4 = ((ByteBuf)referenceCounted).readableBytes();
                while (n4 > 0) {
                    this.doWriteBytes((ByteBuf)referenceCounted);
                    int n7 = ((ByteBuf)referenceCounted).readableBytes();
                    channelOutboundBuffer.progress(n4 - n7);
                    n4 = n7;
                }
                channelOutboundBuffer.remove();
                continue;
            }
            if (object instanceof FileRegion) {
                referenceCounted = (FileRegion)object;
                long l2 = referenceCounted.transferred();
                this.doWriteFileRegion((FileRegion)referenceCounted);
                channelOutboundBuffer.progress(referenceCounted.transferred() - l2);
                channelOutboundBuffer.remove();
                continue;
            }
            channelOutboundBuffer.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object)));
        }
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf || object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract void doWriteBytes(ByteBuf var1);

    protected abstract void doWriteFileRegion(FileRegion var1);
}

