/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.nio;

import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.EventLoopException;
import io.grpc.netty.shaded.io.netty.channel.EventLoopTaskQueueFactory;
import io.grpc.netty.shaded.io.netty.channel.SelectStrategy;
import io.grpc.netty.shaded.io.netty.channel.SingleThreadEventLoop;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$1;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$2;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$3;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$4;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$5;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$6;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop$SelectorTuple;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.nio.NioTask;
import io.grpc.netty.shaded.io.netty.channel.nio.SelectedSelectionKeySet;
import io.grpc.netty.shaded.io.netty.channel.nio.SelectedSelectionKeySetSelector;
import io.grpc.netty.shaded.io.netty.util.IntSupplier;
import io.grpc.netty.shaded.io.netty.util.concurrent.RejectedExecutionHandler;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new NioEventLoop$1(this);
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup nioEventLoopGroup, Executor executor, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        super(nioEventLoopGroup, executor, false, NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), rejectedExecutionHandler);
        if (selectorProvider == null) {
            throw new NullPointerException("selectorProvider");
        }
        if (selectStrategy == null) {
            throw new NullPointerException("selectStrategy");
        }
        this.provider = selectorProvider;
        NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple = this.openSelector();
        this.selector = nioEventLoop$SelectorTuple.selector;
        this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
        this.selectStrategy = selectStrategy;
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return NioEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    private NioEventLoop$SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        Object object = AccessController.doPrivileged(new NioEventLoop$3(this));
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)throwable);
            }
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        Class clazz = (Class)object;
        SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        Object object2 = AccessController.doPrivileged(new NioEventLoop$4(this, clazz, abstractSelector, selectedSelectionKeySet));
        if (object2 instanceof Exception) {
            this.selectedKeys = null;
            Exception exception = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)exception);
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", (Object)abstractSelector);
        return new NioEventLoop$SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    public SelectorProvider selectorProvider() {
        return this.provider;
    }

    @Override
    public Queue<Runnable> newTaskQueue(int n4) {
        return NioEventLoop.newTaskQueue0(n4);
    }

    private static Queue<Runnable> newTaskQueue0(int n4) {
        return n4 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n4);
    }

    public void register(SelectableChannel selectableChannel, int n4, NioTask<?> nioTask) {
        if (selectableChannel == null) {
            throw new NullPointerException("ch");
        }
        if (n4 == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((n4 & ~selectableChannel.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + n4 + "(validOps: " + selectableChannel.validOps() + ')');
        }
        if (nioTask == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        if (this.inEventLoop()) {
            this.register0(selectableChannel, n4, nioTask);
        } else {
            try {
                this.submit(new NioEventLoop$5(this, selectableChannel, n4, nioTask)).sync();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void register0(SelectableChannel selectableChannel, int n4, NioTask<?> nioTask) {
        try {
            selectableChannel.register(this.unwrappedSelector, n4, nioTask);
        }
        catch (Exception exception) {
            throw new EventLoopException("failed to register a channel", exception);
        }
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n4) {
        if (n4 <= 0 || n4 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n4 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n4;
    }

    public void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new NioEventLoop$6(this));
            return;
        }
        this.rebuildSelector0();
    }

    @Override
    public int registeredChannels() {
        return this.selector.keys().size() - this.cancelledKeys;
    }

    private void rebuildSelector0() {
        int n4;
        block11: {
            NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                nioEventLoop$SelectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n4 = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                Object object2 = selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(nioEventLoop$SelectorTuple.unwrappedSelector) != null) continue;
                    int n7 = selectionKey.interestOps();
                    selectionKey.cancel();
                    object = selectionKey.channel().register(nioEventLoop$SelectorTuple.unwrappedSelector, n7, object2);
                    if (object2 instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)object2).selectionKey = object;
                    }
                    ++n4;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                    if (object2 instanceof AbstractNioChannel) {
                        object = (AbstractNioChannel)object2;
                        ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                        continue;
                    }
                    object = (NioTask)object2;
                    NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                }
            }
            this.selector = nioEventLoop$SelectorTuple.selector;
            this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + n4 + " channel(s) to the new Selector.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            block20: {
                try {
                    while (true) {
                        try {
                            block18: while (true) {
                                switch (this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks())) {
                                    case -2: {
                                        continue block18;
                                    }
                                    case -3: 
                                    case -1: {
                                        this.select(this.wakenUp.getAndSet(false));
                                        if (!this.wakenUp.get()) break block18;
                                        this.selector.wakeup();
                                    }
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            this.rebuildSelector0();
                            NioEventLoop.handleLoopException(iOException);
                            continue;
                        }
                        break;
                    }
                    this.cancelledKeys = 0;
                    this.needsToSelectAgain = false;
                    int n4 = this.ioRatio;
                    if (n4 == 100) {
                        try {
                            this.processSelectedKeys();
                            break block20;
                        }
                        finally {
                            this.runAllTasks();
                        }
                    }
                    long l2 = System.nanoTime();
                    try {
                        this.processSelectedKeys();
                    }
                    finally {
                        long l10 = System.nanoTime() - l2;
                        this.runAllTasks(l10 * (long)(100 - n4) / (long)n4);
                    }
                }
                catch (Throwable throwable) {
                    NioEventLoop.handleLoopException(throwable);
                }
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
                return;
            }
            catch (Throwable throwable) {
                NioEventLoop.handleLoopException(throwable);
                continue;
            }
            break;
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
        } else {
            this.processSelectedKeysPlain(this.selector.selectedKeys());
        }
    }

    @Override
    public void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
    }

    void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    @Override
    public Runnable pollTask() {
        Runnable runnable = super.pollTask();
        if (this.needsToSelectAgain) {
            this.selectAgain();
        }
        return runnable;
    }

    private void processSelectedKeysPlain(Set<SelectionKey> set) {
        if (set.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        while (true) {
            SelectionKey selectionKey = iterator.next();
            Object object = selectionKey.attachment();
            iterator.remove();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!iterator.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            set = this.selector.selectedKeys();
            if (set.isEmpty()) break;
            iterator = set.iterator();
        }
    }

    private void processSelectedKeysOptimized() {
        for (int i3 = 0; i3 < this.selectedKeys.size; ++i3) {
            SelectionKey selectionKey = this.selectedKeys.keys[i3];
            this.selectedKeys.keys[i3] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i3 + 1);
            this.selectAgain();
            i3 = -1;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop != this || nioEventLoop == null) {
                return;
            }
            abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
            return;
        }
        try {
            int n4 = selectionKey.readyOps();
            if ((n4 & 8) != 0) {
                int n7 = selectionKey.interestOps();
                selectionKey.interestOps(n7 &= 0xFFFFFFF7);
                abstractNioChannel$NioUnsafe.finishConnect();
            }
            if ((n4 & 4) != 0) {
                abstractNioChannel.unsafe().forceFlush();
            }
            if ((n4 & 0x11) != 0 || n4 == 0) {
                abstractNioChannel$NioUnsafe.read();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        int n4 = 0;
        try {
            nioTask.channelReady(selectionKey.channel(), selectionKey);
            n4 = 1;
        }
        catch (Exception exception) {
            selectionKey.cancel();
            NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
            n4 = 2;
        }
        finally {
            switch (n4) {
                case 0: {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    break;
                }
                case 1: {
                    if (selectionKey.isValid()) break;
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                }
            }
        }
    }

    private void closeAll() {
        this.selectAgain();
        Set<SelectionKey> set = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(set.size());
        for (SelectionKey object : set) {
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            NioTask nioTask = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered(nioTask, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
        }
    }

    @Override
    public void wakeup(boolean bl3) {
        if (!bl3 && this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    int selectNow() {
        try {
            int n4 = this.selector.selectNow();
            return n4;
        }
        finally {
            if (this.wakenUp.get()) {
                this.selector.wakeup();
            }
        }
    }

    private void select(boolean bl3) {
        block11: {
            Selector selector = this.selector;
            try {
                int n4 = 0;
                long l2 = System.nanoTime();
                long l10 = l2 + this.delayNanos(l2);
                while (true) {
                    long l11;
                    if ((l11 = (l10 - l2 + 500000L) / 1000000L) <= 0L) {
                        if (n4 != 0) break;
                        selector.selectNow();
                        n4 = 1;
                        break;
                    }
                    if (this.hasTasks() && this.wakenUp.compareAndSet(false, true)) {
                        selector.selectNow();
                        n4 = 1;
                        break;
                    }
                    int n7 = selector.select(l11);
                    ++n4;
                    if (n7 != 0 || bl3 || this.wakenUp.get() || this.hasTasks() || this.hasScheduledTasks()) break;
                    if (Thread.interrupted()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
                        }
                        n4 = 1;
                        break;
                    }
                    long l12 = System.nanoTime();
                    if (l12 - TimeUnit.MILLISECONDS.toNanos(l11) >= l2) {
                        n4 = 1;
                    } else if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n4 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
                        selector = this.selectRebuildSelector(n4);
                        n4 = 1;
                        break;
                    }
                    l2 = l12;
                }
                if (n4 > 3 && logger.isDebugEnabled()) {
                    logger.debug("Selector.select() returned prematurely {} times in a row for Selector {}.", (Object)(n4 - 1), (Object)selector);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector {} - JDK bug?", (Object)selector, (Object)cancelledKeyException);
            }
        }
    }

    private Selector selectRebuildSelector(int n4) {
        logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n4, (Object)this.selector);
        this.rebuildSelector();
        Selector selector = this.selector;
        selector.selectNow();
        return selector;
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
        }
    }

    static /* synthetic */ void access$000(NioEventLoop nioEventLoop, SelectableChannel selectableChannel, int n4, NioTask nioTask) {
        nioEventLoop.register0(selectableChannel, n4, nioTask);
    }

    static /* synthetic */ void access$100(NioEventLoop nioEventLoop) {
        nioEventLoop.rebuildSelector0();
    }

    static {
        int n4;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.noKeySetOptimization", false);
        String string = "sun.nio.ch.bugLevel";
        String string2 = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
        if (string2 == null) {
            try {
                AccessController.doPrivileged(new NioEventLoop$2());
            }
            catch (SecurityException securityException) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
            }
        }
        if ((n4 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n4 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n4;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }
}

