/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.nio;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioMessageChannel$NioMessageUnsafe;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n4) {
        super(channel, selectableChannel, n4);
    }

    @Override
    protected AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new AbstractNioMessageChannel$NioMessageUnsafe(this, null);
    }

    @Override
    public void doBeginRead() {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        SelectionKey selectionKey = this.selectionKey();
        int n4 = selectionKey.interestOps();
        while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                if ((n4 & 4) == 0) break;
                selectionKey.interestOps(n4 & 0xFFFFFFFB);
                break;
            }
            try {
                boolean bl3 = false;
                for (int i3 = this.config().getWriteSpinCount() - 1; i3 >= 0; --i3) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                if ((n4 & 4) != 0) break;
                selectionKey.interestOps(n4 | 4);
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1);

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2);
}

