/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.nio;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$1;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$2;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoop;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ScheduledFuture;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new AbstractNioChannel$1(this);
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n4) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = n4;
        try {
            selectableChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            block4: {
                try {
                    selectableChannel.close();
                }
                catch (IOException iOException2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to close a partially initialized socket.", iOException2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public AbstractNioChannel$NioUnsafe unsafe() {
        return (AbstractNioChannel$NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    @Override
    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    @Deprecated
    protected boolean isReadPending() {
        return this.readPending;
    }

    @Deprecated
    protected void setReadPending(boolean bl3) {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.setReadPending0(bl3);
            } else {
                nioEventLoop.execute(new AbstractNioChannel$2(this, bl3));
            }
        } else {
            this.readPending = bl3;
        }
    }

    public final void clearReadPending() {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.clearReadPending0();
            } else {
                nioEventLoop.execute(this.clearReadPendingRunnable);
            }
        } else {
            this.readPending = false;
        }
    }

    private void setReadPending0(boolean bl3) {
        this.readPending = bl3;
        if (!bl3) {
            ((AbstractNioChannel$AbstractNioUnsafe)this.unsafe()).removeReadOp();
        }
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioChannel$AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof NioEventLoop;
    }

    @Override
    public void doRegister() {
        boolean bl3 = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().unwrappedSelector(), 0, this);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl3) {
                    this.eventLoop().selectNow();
                    bl3 = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    @Override
    public void doDeregister() {
        this.eventLoop().cancel(this.selectionKey());
    }

    @Override
    public void doBeginRead() {
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int n4 = selectionKey.interestOps();
        if ((n4 & this.readInterestOp) == 0) {
            selectionKey.interestOps(n4 | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2);

    protected abstract void doFinishConnect();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n4);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf3;
        }
        return byteBuf;
    }

    protected final ByteBuf newDirectBuffer(ReferenceCounted referenceCounted, ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n4);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf3;
        }
        if (referenceCounted != byteBuf) {
            byteBuf.retain();
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
        return byteBuf;
    }

    @Override
    public void doClose() {
        ScheduledFuture<?> scheduledFuture;
        ChannelPromise channelPromise = this.connectPromise;
        if (channelPromise != null) {
            channelPromise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((scheduledFuture = this.connectTimeoutFuture) != null) {
            scheduledFuture.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    static /* synthetic */ void access$000(AbstractNioChannel abstractNioChannel) {
        abstractNioChannel.clearReadPending0();
    }

    static /* synthetic */ void access$100(AbstractNioChannel abstractNioChannel, boolean bl3) {
        abstractNioChannel.setReadPending0(bl3);
    }

    static /* synthetic */ ChannelPromise access$200(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$202(AbstractNioChannel abstractNioChannel, ChannelPromise channelPromise) {
        abstractNioChannel.connectPromise = channelPromise;
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$302(AbstractNioChannel abstractNioChannel, SocketAddress socketAddress) {
        abstractNioChannel.requestedRemoteAddress = socketAddress;
        return abstractNioChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$402(AbstractNioChannel abstractNioChannel, ScheduledFuture scheduledFuture) {
        abstractNioChannel.connectTimeoutFuture = scheduledFuture;
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$400(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$300(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.requestedRemoteAddress;
    }
}

