/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.nio;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioByteChannel$1;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioByteChannel$NioByteUnsafe;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannelConfig;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private final Runnable flushTask = new AbstractNioByteChannel$1(this);
    private boolean inputClosedSeenErrorOnRead;

    protected AbstractNioByteChannel(Channel channel, SelectableChannel selectableChannel) {
        super(channel, selectableChannel, 1);
    }

    protected abstract ChannelFuture shutdownInput();

    protected boolean isInputShutdown0() {
        return false;
    }

    @Override
    protected AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new AbstractNioByteChannel$NioByteUnsafe(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    final boolean shouldBreakReadReady(ChannelConfig channelConfig) {
        return this.isInputShutdown0() && (this.inputClosedSeenErrorOnRead || !AbstractNioByteChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    protected final int doWrite0(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object == null) {
            return 0;
        }
        return this.doWriteInternal(channelOutboundBuffer, channelOutboundBuffer.current());
    }

    private int doWriteInternal(ChannelOutboundBuffer channelOutboundBuffer, Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!byteBuf.isReadable()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            int n4 = this.doWriteBytes(byteBuf);
            if (n4 > 0) {
                channelOutboundBuffer.progress(n4);
                if (!byteBuf.isReadable()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else if (object instanceof FileRegion) {
            FileRegion fileRegion = (FileRegion)object;
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            long l2 = this.doWriteFileRegion(fileRegion);
            if (l2 > 0L) {
                channelOutboundBuffer.progress(l2);
                if (fileRegion.transferred() >= fileRegion.count()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else {
            throw new Error();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        int n4 = this.config().getWriteSpinCount();
        do {
            if ((object = channelOutboundBuffer.current()) != null) continue;
            this.clearOpWrite();
            return;
        } while ((n4 -= this.doWriteInternal(channelOutboundBuffer, object)) > 0);
        this.incompleteWrite(n4 < 0);
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (byteBuf.isDirect()) {
                return object;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean bl3) {
        if (bl3) {
            this.setOpWrite();
        } else {
            this.clearOpWrite();
            this.eventLoop().execute(this.flushTask);
        }
    }

    protected abstract long doWriteFileRegion(FileRegion var1);

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract int doWriteBytes(ByteBuf var1);

    protected final void setOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n4 = selectionKey.interestOps();
        if ((n4 & 4) == 0) {
            selectionKey.interestOps(n4 | 4);
        }
    }

    protected final void clearOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n4 = selectionKey.interestOps();
        if ((n4 & 4) != 0) {
            selectionKey.interestOps(n4 & 0xFFFFFFFB);
        }
    }

    static /* synthetic */ boolean access$000(ChannelConfig channelConfig) {
        return AbstractNioByteChannel.isAllowHalfClosure(channelConfig);
    }

    static /* synthetic */ boolean access$102(AbstractNioByteChannel abstractNioByteChannel, boolean bl3) {
        abstractNioByteChannel.inputClosedSeenErrorOnRead = bl3;
        return abstractNioByteChannel.inputClosedSeenErrorOnRead;
    }
}

