/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.group;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufHolder;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelId;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.channel.group.ChannelGroup;
import io.grpc.netty.shaded.io.netty.channel.group.ChannelGroupFuture;
import io.grpc.netty.shaded.io.netty.channel.group.ChannelMatcher;
import io.grpc.netty.shaded.io.netty.channel.group.ChannelMatchers;
import io.grpc.netty.shaded.io.netty.channel.group.CombinedIterator;
import io.grpc.netty.shaded.io.netty.channel.group.DefaultChannelGroup$1;
import io.grpc.netty.shaded.io.netty.channel.group.DefaultChannelGroupFuture;
import io.grpc.netty.shaded.io.netty.channel.group.VoidChannelGroupFuture;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final EventExecutor executor;
    private final ConcurrentMap<ChannelId, Channel> serverChannels = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<ChannelId, Channel> nonServerChannels = PlatformDependent.newConcurrentHashMap();
    private final ChannelFutureListener remover = new DefaultChannelGroup$1(this);
    private final VoidChannelGroupFuture voidFuture = new VoidChannelGroupFuture(this);
    private final boolean stayClosed;
    private volatile boolean closed;

    public DefaultChannelGroup(EventExecutor eventExecutor) {
        this(eventExecutor, false);
    }

    public DefaultChannelGroup(String string, EventExecutor eventExecutor) {
        this(string, eventExecutor, false);
    }

    public DefaultChannelGroup(EventExecutor eventExecutor, boolean bl3) {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()), eventExecutor, bl3);
    }

    public DefaultChannelGroup(String string, EventExecutor eventExecutor, boolean bl3) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.name = string;
        this.executor = eventExecutor;
        this.stayClosed = bl3;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Channel find(ChannelId channelId) {
        Channel channel = (Channel)this.nonServerChannels.get(channelId);
        if (channel != null) {
            return channel;
        }
        return (Channel)this.serverChannels.get(channelId);
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof ServerChannel) {
            return this.serverChannels.containsValue(object);
        }
        if (object instanceof Channel) {
            return this.nonServerChannels.containsValue(object);
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        boolean bl3;
        ConcurrentMap<ChannelId, Channel> concurrentMap = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl4 = bl3 = concurrentMap.putIfAbsent(channel.id(), channel) == null;
        if (bl3) {
            channel.closeFuture().addListener(this.remover);
        }
        if (this.stayClosed && this.closed) {
            channel.close();
        }
        return bl3;
    }

    @Override
    public boolean remove(Object object) {
        Channel channel = null;
        if (object instanceof ChannelId) {
            channel = (Channel)this.nonServerChannels.remove(object);
            if (channel == null) {
                channel = (Channel)this.serverChannels.remove(object);
            }
        } else if (object instanceof Channel) {
            channel = (Channel)object;
            channel = channel instanceof ServerChannel ? (Channel)this.serverChannels.remove(channel.id()) : (Channel)this.nonServerChannels.remove(channel.id());
        }
        if (channel == null) {
            return false;
        }
        channel.closeFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this.serverChannels.values());
        arrayList.addAll(this.nonServerChannels.values());
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this.serverChannels.values());
        arrayList.addAll(this.nonServerChannels.values());
        return arrayList.toArray(TArray);
    }

    @Override
    public ChannelGroupFuture close() {
        return this.close(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture disconnect() {
        return this.disconnect(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture deregister() {
        return this.deregister(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture write(Object object) {
        return this.write(object, ChannelMatchers.all());
    }

    private static Object safeDuplicate(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).retainedDuplicate();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).retainedDuplicate();
        }
        return ReferenceCountUtil.retain(object);
    }

    @Override
    public ChannelGroupFuture write(Object object, ChannelMatcher channelMatcher) {
        return this.write(object, channelMatcher, false);
    }

    @Override
    public ChannelGroupFuture write(Object object, ChannelMatcher channelMatcher, boolean bl3) {
        ChannelGroupFuture channelGroupFuture;
        if (object == null) {
            throw new NullPointerException("message");
        }
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        if (bl3) {
            for (Channel channel : this.nonServerChannels.values()) {
                if (!channelMatcher.matches(channel)) continue;
                channel.write(DefaultChannelGroup.safeDuplicate(object), channel.voidPromise());
            }
            channelGroupFuture = this.voidFuture;
        } else {
            LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
            for (Channel channel : this.nonServerChannels.values()) {
                if (!channelMatcher.matches(channel)) continue;
                linkedHashMap.put(channel, channel.write(DefaultChannelGroup.safeDuplicate(object)));
            }
            channelGroupFuture = new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
        }
        ReferenceCountUtil.release(object);
        return channelGroupFuture;
    }

    @Override
    public ChannelGroup flush() {
        return this.flush(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture flushAndWrite(Object object) {
        return this.writeAndFlush(object);
    }

    @Override
    public ChannelGroupFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture disconnect(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.disconnect());
        }
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroupFuture close(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        if (this.stayClosed) {
            this.closed = true;
        }
        for (Channel channel : this.serverChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.close());
        }
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroupFuture deregister(ChannelMatcher channelMatcher) {
        if (channelMatcher == null) {
            throw new NullPointerException("matcher");
        }
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.deregister());
        }
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.deregister());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public ChannelGroup flush(ChannelMatcher channelMatcher) {
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            channel.flush();
        }
        return this;
    }

    @Override
    public ChannelGroupFuture flushAndWrite(Object object, ChannelMatcher channelMatcher) {
        return this.writeAndFlush(object, channelMatcher);
    }

    @Override
    public ChannelGroupFuture writeAndFlush(Object object, ChannelMatcher channelMatcher) {
        return this.writeAndFlush(object, channelMatcher, false);
    }

    @Override
    public ChannelGroupFuture writeAndFlush(Object object, ChannelMatcher channelMatcher, boolean bl3) {
        ChannelGroupFuture channelGroupFuture;
        if (object == null) {
            throw new NullPointerException("message");
        }
        if (bl3) {
            for (Channel channel : this.nonServerChannels.values()) {
                if (!channelMatcher.matches(channel)) continue;
                channel.writeAndFlush(DefaultChannelGroup.safeDuplicate(object), channel.voidPromise());
            }
            channelGroupFuture = this.voidFuture;
        } else {
            LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
            for (Channel channel : this.nonServerChannels.values()) {
                if (!channelMatcher.matches(channel)) continue;
                linkedHashMap.put(channel, channel.writeAndFlush(DefaultChannelGroup.safeDuplicate(object)));
            }
            channelGroupFuture = new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
        }
        ReferenceCountUtil.release(object);
        return channelGroupFuture;
    }

    @Override
    public ChannelGroupFuture newCloseFuture() {
        return this.newCloseFuture(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture newCloseFuture(ChannelMatcher channelMatcher) {
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel channel : this.serverChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.closeFuture());
        }
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.closeFuture());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, linkedHashMap, this.executor);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(ChannelGroup channelGroup) {
        int n4 = this.name().compareTo(channelGroup.name());
        if (n4 != 0) {
            return n4;
        }
        return System.identityHashCode(this) - System.identityHashCode(channelGroup);
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(name: " + this.name() + ", size: " + this.size() + ')';
    }
}

