/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.socket.DatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.unix.IovArray;
import io.grpc.netty.shaded.io.netty.channel.unix.Limits;
import java.net.InetSocketAddress;

final class NativeDatagramPacketArray
implements ChannelOutboundBuffer$MessageProcessor {
    private final NativeDatagramPacketArray$NativeDatagramPacket[] packets = new NativeDatagramPacketArray$NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private final IovArray iovArray = new IovArray();
    private int count;

    NativeDatagramPacketArray() {
        for (int i3 = 0; i3 < this.packets.length; ++i3) {
            this.packets[i3] = new NativeDatagramPacketArray$NativeDatagramPacket();
        }
    }

    boolean add(DatagramPacket datagramPacket) {
        if (this.count == this.packets.length) {
            return false;
        }
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            return true;
        }
        NativeDatagramPacketArray$NativeDatagramPacket nativeDatagramPacketArray$NativeDatagramPacket = this.packets[this.count];
        InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.recipient();
        int n7 = this.iovArray.count();
        if (!this.iovArray.add(byteBuf)) {
            return false;
        }
        NativeDatagramPacketArray$NativeDatagramPacket.access$000(nativeDatagramPacketArray$NativeDatagramPacket, this.iovArray.memoryAddress(n7), this.iovArray.count() - n7, inetSocketAddress);
        ++this.count;
        return true;
    }

    @Override
    public boolean processMessage(Object object) {
        return object instanceof DatagramPacket && this.add((DatagramPacket)object);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacketArray$NativeDatagramPacket[] packets() {
        return this.packets;
    }

    void clear() {
        this.count = 0;
        this.iovArray.clear();
    }

    void release() {
        this.iovArray.release();
    }
}

