/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventArray;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeStaticallyReferencedJniMethods;
import io.grpc.netty.shaded.io.netty.channel.unix.Errors;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.channel.unix.Socket;
import io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryLoader;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ThrowableUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Locale;

public final class Native {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Native.class);
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLLRDHUP;
    public static final int EPOLLET;
    public static final int EPOLLERR;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    public static final boolean IS_SUPPORTING_TCP_FASTOPEN;
    public static final int TCP_MD5SIG_MAXKEYLEN;
    public static final String KERNEL_VERSION;

    public static FileDescriptor newEventFd() {
        return new FileDescriptor(Native.eventFd());
    }

    public static FileDescriptor newTimerFd() {
        return new FileDescriptor(Native.timerFd());
    }

    private static native int eventFd();

    private static native int timerFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    static native void timerFdRead(int var0);

    public static FileDescriptor newEpollCreate() {
        return new FileDescriptor(Native.epollCreate());
    }

    private static native int epollCreate();

    public static int epollWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray, FileDescriptor fileDescriptor2, int n4, int n7) {
        int n8 = Native.epollWait0(fileDescriptor.intValue(), epollEventArray.memoryAddress(), epollEventArray.length(), fileDescriptor2.intValue(), n4, n7);
        if (n8 < 0) {
            throw Errors.newIOException("epoll_wait", n8);
        }
        return n8;
    }

    private static native int epollWait0(int var0, long var1, int var3, int var4, int var5, int var6);

    public static int epollBusyWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray) {
        int n4 = Native.epollBusyWait0(fileDescriptor.intValue(), epollEventArray.memoryAddress(), epollEventArray.length());
        if (n4 < 0) {
            throw Errors.newIOException("epoll_wait", n4);
        }
        return n4;
    }

    private static native int epollBusyWait0(int var0, long var1, int var3);

    public static void epollCtlAdd(int n4, int n7, int n8) {
        int n10 = Native.epollCtlAdd0(n4, n7, n8);
        if (n10 < 0) {
            throw Errors.newIOException("epoll_ctl", n10);
        }
    }

    private static native int epollCtlAdd0(int var0, int var1, int var2);

    public static void epollCtlMod(int n4, int n7, int n8) {
        int n10 = Native.epollCtlMod0(n4, n7, n8);
        if (n10 < 0) {
            throw Errors.newIOException("epoll_ctl", n10);
        }
    }

    private static native int epollCtlMod0(int var0, int var1, int var2);

    public static void epollCtlDel(int n4, int n7) {
        int n8 = Native.epollCtlDel0(n4, n7);
        if (n8 < 0) {
            throw Errors.newIOException("epoll_ctl", n8);
        }
    }

    private static native int epollCtlDel0(int var0, int var1);

    public static int splice(int n4, long l2, int n7, long l10, long l11) {
        int n8 = Native.splice0(n4, l2, n7, l10, l11);
        if (n8 >= 0) {
            return n8;
        }
        return Errors.ioResult("splice", n8);
    }

    private static native int splice0(int var0, long var1, int var3, long var4, long var6);

    @Deprecated
    public static int sendmmsg(int n4, NativeDatagramPacketArray$NativeDatagramPacket[] nativeDatagramPacketArray$NativeDatagramPacketArray, int n7, int n8) {
        return Native.sendmmsg(n4, Socket.isIPv6Preferred(), nativeDatagramPacketArray$NativeDatagramPacketArray, n7, n8);
    }

    static int sendmmsg(int n4, boolean bl3, NativeDatagramPacketArray$NativeDatagramPacket[] nativeDatagramPacketArray$NativeDatagramPacketArray, int n7, int n8) {
        int n10 = Native.sendmmsg0(n4, bl3, nativeDatagramPacketArray$NativeDatagramPacketArray, n7, n8);
        if (n10 >= 0) {
            return n10;
        }
        return Errors.ioResult("sendmmsg", n10);
    }

    private static native int sendmmsg0(int var0, boolean var1, NativeDatagramPacketArray$NativeDatagramPacket[] var2, int var3, int var4);

    public static native int sizeofEpollEvent();

    public static native int offsetofEpollData();

    private static void loadNativeLibrary() {
        String string = SystemPropertyUtil.get("os.name").toLowerCase(Locale.UK).trim();
        if (!string.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        String string2 = "netty_transport_native_epoll";
        String string3 = string2 + '_' + PlatformDependent.normalizedArch();
        ClassLoader classLoader = PlatformDependent.getClassLoader(Native.class);
        try {
            NativeLibraryLoader.load(string3, classLoader);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                NativeLibraryLoader.load(string2, classLoader);
                logger.debug("Failed to load {}", (Object)string3, (Object)unsatisfiedLinkError);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError, unsatisfiedLinkError2);
                throw unsatisfiedLinkError;
            }
        }
    }

    private Native() {
    }

    static {
        try {
            Native.offsetofEpollData();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Native.loadNativeLibrary();
        }
        Socket.initialize();
        EPOLLIN = NativeStaticallyReferencedJniMethods.epollin();
        EPOLLOUT = NativeStaticallyReferencedJniMethods.epollout();
        EPOLLRDHUP = NativeStaticallyReferencedJniMethods.epollrdhup();
        EPOLLET = NativeStaticallyReferencedJniMethods.epollet();
        EPOLLERR = NativeStaticallyReferencedJniMethods.epollerr();
        IS_SUPPORTING_SENDMMSG = NativeStaticallyReferencedJniMethods.isSupportingSendmmsg();
        IS_SUPPORTING_TCP_FASTOPEN = NativeStaticallyReferencedJniMethods.isSupportingTcpFastopen();
        TCP_MD5SIG_MAXKEYLEN = NativeStaticallyReferencedJniMethods.tcpMd5SigMaxKeyLen();
        KERNEL_VERSION = NativeStaticallyReferencedJniMethods.kernelVersion();
    }
}

