/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.MessageSizeEstimator;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.WriteBufferWaterMark;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelOption;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollMode;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannelConfig;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public final class EpollSocketChannelConfig
extends EpollChannelConfig
implements SocketChannelConfig {
    private volatile boolean allowHalfClosure;

    EpollSocketChannelConfig(EpollSocketChannel epollSocketChannel) {
        super(epollSocketChannel);
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
        this.calculateMaxBytesPerGatheringWrite();
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, EpollChannelOption.TCP_CORK, EpollChannelOption.TCP_NOTSENT_LOWAT, EpollChannelOption.TCP_KEEPCNT, EpollChannelOption.TCP_KEEPIDLE, EpollChannelOption.TCP_KEEPINTVL, EpollChannelOption.TCP_MD5SIG, EpollChannelOption.TCP_QUICKACK, EpollChannelOption.IP_TRANSPARENT, EpollChannelOption.TCP_FASTOPEN_CONNECT, EpollChannelOption.SO_BUSY_POLL);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (channelOption == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (channelOption == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (channelOption == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (channelOption == EpollChannelOption.TCP_CORK) {
            return (T)Boolean.valueOf(this.isTcpCork());
        }
        if (channelOption == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            return (T)Long.valueOf(this.getTcpNotSentLowAt());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPIDLE) {
            return (T)Integer.valueOf(this.getTcpKeepIdle());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPINTVL) {
            return (T)Integer.valueOf(this.getTcpKeepIntvl());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPCNT) {
            return (T)Integer.valueOf(this.getTcpKeepCnt());
        }
        if (channelOption == EpollChannelOption.TCP_USER_TIMEOUT) {
            return (T)Integer.valueOf(this.getTcpUserTimeout());
        }
        if (channelOption == EpollChannelOption.TCP_QUICKACK) {
            return (T)Boolean.valueOf(this.isTcpQuickAck());
        }
        if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (channelOption == EpollChannelOption.TCP_FASTOPEN_CONNECT) {
            return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
        }
        if (channelOption == EpollChannelOption.SO_BUSY_POLL) {
            return (T)Integer.valueOf(this.getSoBusyPoll());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t3) {
        this.validate(channelOption, t3);
        if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t3);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t3);
        } else if (channelOption == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)t3);
        } else if (channelOption == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)t3);
        } else if (channelOption == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t3);
        } else if (channelOption == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)t3);
        } else if (channelOption == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)t3);
        } else if (channelOption == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)t3);
        } else if (channelOption == EpollChannelOption.TCP_CORK) {
            this.setTcpCork((Boolean)t3);
        } else if (channelOption == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            this.setTcpNotSentLowAt((Long)t3);
        } else if (channelOption == EpollChannelOption.TCP_KEEPIDLE) {
            this.setTcpKeepIdle((Integer)t3);
        } else if (channelOption == EpollChannelOption.TCP_KEEPCNT) {
            this.setTcpKeepCnt((Integer)t3);
        } else if (channelOption == EpollChannelOption.TCP_KEEPINTVL) {
            this.setTcpKeepIntvl((Integer)t3);
        } else if (channelOption == EpollChannelOption.TCP_USER_TIMEOUT) {
            this.setTcpUserTimeout((Integer)t3);
        } else if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)t3);
        } else if (channelOption == EpollChannelOption.TCP_MD5SIG) {
            Map map = (Map)t3;
            this.setTcpMd5Sig(map);
        } else if (channelOption == EpollChannelOption.TCP_QUICKACK) {
            this.setTcpQuickAck((Boolean)t3);
        } else if (channelOption == EpollChannelOption.TCP_FASTOPEN_CONNECT) {
            this.setTcpFastOpenConnect((Boolean)t3);
        } else if (channelOption == EpollChannelOption.SO_BUSY_POLL) {
            this.setSoBusyPoll((Integer)t3);
        } else {
            return super.setOption(channelOption, t3);
        }
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getSendBufferSize() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getSoLinger() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getSoLinger();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getTrafficClass() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTrafficClass();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isKeepAlive() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isKeepAlive();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isReuseAddress() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isTcpNoDelay() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isTcpNoDelay();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isTcpCork() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isTcpCork();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getSoBusyPoll() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getSoBusyPoll();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public long getTcpNotSentLowAt() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTcpNotSentLowAt();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepIdle() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTcpKeepIdle();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepIntvl() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTcpKeepIntvl();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepCnt() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTcpKeepCnt();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpUserTimeout() {
        try {
            return ((EpollSocketChannel)this.channel).socket.getTcpUserTimeout();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setKeepAlive(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setKeepAlive(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setPerformancePreferences(int n4, int n7, int n8) {
        return this;
    }

    @Override
    public EpollSocketChannelConfig setReceiveBufferSize(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setReceiveBufferSize(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setReuseAddress(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setReuseAddress(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setSendBufferSize(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setSendBufferSize(n4);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setSoLinger(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setSoLinger(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setTcpNoDelay(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpNoDelay(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpCork(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpCork(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setSoBusyPoll(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setSoBusyPoll(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpNotSentLowAt(long l2) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpNotSentLowAt(l2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setTrafficClass(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTrafficClass(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpKeepIdle(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpKeepIdle(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpKeepIntvl(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpKeepIntvl(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Deprecated
    public EpollSocketChannelConfig setTcpKeepCntl(int n4) {
        return this.setTcpKeepCnt(n4);
    }

    public EpollSocketChannelConfig setTcpKeepCnt(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpKeepCnt(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpUserTimeout(int n4) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpUserTimeout(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setIpTransparent(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setIpTransparent(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        try {
            ((EpollSocketChannel)this.channel).setTcpMd5Sig(map);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpQuickAck(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpQuickAck(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isTcpQuickAck() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isTcpQuickAck();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpFastOpenConnect(boolean bl3) {
        try {
            ((EpollSocketChannel)this.channel).socket.setTcpFastOpenConnect(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isTcpFastOpenConnect() {
        try {
            return ((EpollSocketChannel)this.channel).socket.isTcpFastOpenConnect();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public EpollSocketChannelConfig setAllowHalfClosure(boolean bl3) {
        this.allowHalfClosure = bl3;
        return this;
    }

    @Override
    public EpollSocketChannelConfig setConnectTimeoutMillis(int n4) {
        super.setConnectTimeoutMillis(n4);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setMaxMessagesPerRead(int n4) {
        super.setMaxMessagesPerRead(n4);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setWriteSpinCount(int n4) {
        super.setWriteSpinCount(n4);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAutoRead(boolean bl3) {
        super.setAutoRead(bl3);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAutoClose(boolean bl3) {
        super.setAutoClose(bl3);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setWriteBufferHighWaterMark(int n4) {
        super.setWriteBufferHighWaterMark(n4);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setWriteBufferLowWaterMark(int n4) {
        super.setWriteBufferLowWaterMark(n4);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setEpollMode(EpollMode epollMode) {
        super.setEpollMode(epollMode);
        return this;
    }

    private void calculateMaxBytesPerGatheringWrite() {
        int n4 = this.getSendBufferSize() << 1;
        if (n4 > 0) {
            this.setMaxBytesPerGatheringWrite(this.getSendBufferSize() << 1);
        }
    }
}

