/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.MessageSizeEstimator;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.WriteBufferWaterMark;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelOption;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.ServerSocketChannelConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public final class EpollServerSocketChannelConfig
extends EpollServerChannelConfig
implements ServerSocketChannelConfig {
    EpollServerSocketChannelConfig(EpollServerSocketChannel epollServerSocketChannel) {
        super(epollServerSocketChannel);
        this.setReuseAddress(true);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), EpollChannelOption.SO_REUSEPORT, EpollChannelOption.IP_FREEBIND, EpollChannelOption.IP_TRANSPARENT, EpollChannelOption.TCP_DEFER_ACCEPT);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == EpollChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (channelOption == EpollChannelOption.IP_FREEBIND) {
            return (T)Boolean.valueOf(this.isFreeBind());
        }
        if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (channelOption == EpollChannelOption.TCP_DEFER_ACCEPT) {
            return (T)Integer.valueOf(this.getTcpDeferAccept());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t3) {
        this.validate(channelOption, t3);
        if (channelOption == EpollChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)t3);
        } else if (channelOption == EpollChannelOption.IP_FREEBIND) {
            this.setFreeBind((Boolean)t3);
        } else if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)t3);
        } else if (channelOption == EpollChannelOption.TCP_MD5SIG) {
            Map map = (Map)t3;
            this.setTcpMd5Sig(map);
        } else if (channelOption == EpollChannelOption.TCP_DEFER_ACCEPT) {
            this.setTcpDeferAccept((Integer)t3);
        } else {
            return super.setOption(channelOption, t3);
        }
        return true;
    }

    @Override
    public EpollServerSocketChannelConfig setReuseAddress(boolean bl3) {
        super.setReuseAddress(bl3);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setReceiveBufferSize(int n4) {
        super.setReceiveBufferSize(n4);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setPerformancePreferences(int n4, int n7, int n8) {
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setBacklog(int n4) {
        super.setBacklog(n4);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setConnectTimeoutMillis(int n4) {
        super.setConnectTimeoutMillis(n4);
        return this;
    }

    @Override
    @Deprecated
    public EpollServerSocketChannelConfig setMaxMessagesPerRead(int n4) {
        super.setMaxMessagesPerRead(n4);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setWriteSpinCount(int n4) {
        super.setWriteSpinCount(n4);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setAutoRead(boolean bl3) {
        super.setAutoRead(bl3);
        return this;
    }

    @Override
    @Deprecated
    public EpollServerSocketChannelConfig setWriteBufferHighWaterMark(int n4) {
        super.setWriteBufferHighWaterMark(n4);
        return this;
    }

    @Override
    @Deprecated
    public EpollServerSocketChannelConfig setWriteBufferLowWaterMark(int n4) {
        super.setWriteBufferLowWaterMark(n4);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public EpollServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    public EpollServerSocketChannelConfig setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        try {
            ((EpollServerSocketChannel)this.channel).setTcpMd5Sig(map);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isReusePort() {
        try {
            return ((EpollServerSocketChannel)this.channel).socket.isReusePort();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollServerSocketChannelConfig setReusePort(boolean bl3) {
        try {
            ((EpollServerSocketChannel)this.channel).socket.setReusePort(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isFreeBind() {
        try {
            return ((EpollServerSocketChannel)this.channel).socket.isIpFreeBind();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollServerSocketChannelConfig setFreeBind(boolean bl3) {
        try {
            ((EpollServerSocketChannel)this.channel).socket.setIpFreeBind(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((EpollServerSocketChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollServerSocketChannelConfig setIpTransparent(boolean bl3) {
        try {
            ((EpollServerSocketChannel)this.channel).socket.setIpTransparent(bl3);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollServerSocketChannelConfig setTcpDeferAccept(int n4) {
        try {
            ((EpollServerSocketChannel)this.channel).socket.setTcpDeferAccept(n4);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpDeferAccept() {
        try {
            return ((EpollServerSocketChannel)this.channel).socket.getTcpDeferAccept();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }
}

