/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.EventLoopTaskQueueFactory;
import io.grpc.netty.shaded.io.netty.channel.SelectStrategy;
import io.grpc.netty.shaded.io.netty.channel.SingleThreadEventLoop;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventArray;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoop$1;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.channel.unix.IovArray;
import io.grpc.netty.shaded.io.netty.util.IntSupplier;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import io.grpc.netty.shaded.io.netty.util.concurrent.RejectedExecutionHandler;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final AtomicIntegerFieldUpdater<EpollEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(EpollEventLoop.class, "wakenUp");
    private long prevDeadlineNanos = EpollEventLoop.nanoTime() - 1L;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new EpollEventLoop$1(this);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;
    private static final long MAX_SCHEDULED_TIMERFD_NS = 999999999L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n4, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        super(eventLoopGroup, executor, false, EpollEventLoop.newTaskQueue(eventLoopTaskQueueFactory), EpollEventLoop.newTaskQueue(eventLoopTaskQueueFactory), rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "strategy");
        if (n4 == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(n4);
        }
        boolean bl3 = false;
        FileDescriptor fileDescriptor = null;
        FileDescriptor fileDescriptor2 = null;
        FileDescriptor fileDescriptor3 = null;
        try {
            this.epollFd = fileDescriptor = Native.newEpollCreate();
            this.eventFd = fileDescriptor2 = Native.newEventFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor2.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", iOException);
            }
            this.timerFd = fileDescriptor3 = Native.newTimerFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor3.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", iOException);
            }
            bl3 = true;
        }
        finally {
            if (!bl3) {
                if (fileDescriptor != null) {
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor2 != null) {
                    try {
                        fileDescriptor2.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor3 != null) {
                    try {
                        fileDescriptor3.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return EpollEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    @Override
    public void wakeup(boolean bl3) {
        if (!bl3 && WAKEN_UP_UPDATER.getAndSet(this, 1) == 0) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    void add(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n4 = abstractEpollChannel.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), n4, abstractEpollChannel.flags);
        AbstractEpollChannel abstractEpollChannel2 = this.channels.put(n4, abstractEpollChannel);
        assert (abstractEpollChannel2 == null || !abstractEpollChannel2.isOpen());
    }

    void modify(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), abstractEpollChannel.socket.intValue(), abstractEpollChannel.flags);
    }

    void remove(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n4 = abstractEpollChannel.socket.intValue();
        AbstractEpollChannel abstractEpollChannel2 = this.channels.remove(n4);
        if (abstractEpollChannel2 != null && abstractEpollChannel2 != abstractEpollChannel) {
            this.channels.put(n4, abstractEpollChannel2);
            assert (!abstractEpollChannel.isOpen());
        } else if (abstractEpollChannel.isOpen()) {
            Native.epollCtlDel(this.epollFd.intValue(), n4);
        }
    }

    @Override
    public Queue<Runnable> newTaskQueue(int n4) {
        return EpollEventLoop.newTaskQueue0(n4);
    }

    private static Queue<Runnable> newTaskQueue0(int n4) {
        return n4 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n4);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n4) {
        if (n4 <= 0 || n4 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n4 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n4;
    }

    @Override
    public int registeredChannels() {
        return this.channels.size();
    }

    private int epollWait() {
        int n4;
        int n7;
        long l2 = this.deadlineNanos();
        if (l2 == this.prevDeadlineNanos) {
            n7 = -1;
            n4 = -1;
        } else {
            long l10 = this.delayNanos(System.nanoTime());
            this.prevDeadlineNanos = l2;
            n7 = (int)Math.min(l10 / 1000000000L, Integer.MAX_VALUE);
            n4 = (int)Math.min(l10 - (long)n7 * 1000000000L, 999999999L);
        }
        return Native.epollWait(this.epollFd, this.events, this.timerFd, n7, n4);
    }

    private int epollWaitNow() {
        return Native.epollWait(this.epollFd, this.events, this.timerFd, 0, 0);
    }

    private int epollBusyWait() {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block16: while (true) {
                    var1_1 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (var1_1) {
                        case -2: {
                            continue block16;
                        }
                        case -3: {
                            var1_1 = this.epollBusyWait();
                            break block16;
                        }
                        case -1: {
                            if (this.wakenUp == 1) {
                                this.wakenUp = 0;
                            }
                            if (this.hasTasks()) break block16;
                            var1_1 = this.epollWait();
                        }
                    }
                    break;
                }
                var2_4 = this.ioRatio;
                if (var2_4 == 100) {
                    try {
                        if (var1_1 <= 0) ** GOTO lbl36
                        this.processReady(this.events, var1_1);
                    }
                    finally {
                        this.runAllTasks();
                    }
                } else {
                    var3_5 = System.nanoTime();
                    try {
                        if (var1_1 > 0) {
                            this.processReady(this.events, var1_1);
                        }
                    }
                    finally {
                        var5_7 = System.nanoTime() - var3_5;
                        this.runAllTasks(var5_7 * (long)(100 - var2_4) / (long)var2_4);
                    }
                }
                if (this.allowGrowing && var1_1 == this.events.length()) {
                    this.events.increase();
                }
            }
            catch (Throwable var1_2) {
                this.handleLoopException(var1_2);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable var1_3) {
                this.handleLoopException(var1_3);
                continue;
            }
            break;
        }
    }

    void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeAll() {
        AbstractEpollChannel[] abstractEpollChannelArray;
        try {
            this.epollWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AbstractEpollChannel abstractEpollChannel : abstractEpollChannelArray = this.channels.values().toArray(new AbstractEpollChannel[0])) {
            abstractEpollChannel.unsafe().close(abstractEpollChannel.unsafe().voidPromise());
        }
    }

    private void processReady(EpollEventArray epollEventArray, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            int n7 = epollEventArray.fd(i3);
            if (n7 == this.eventFd.intValue() || n7 == this.timerFd.intValue()) continue;
            long l2 = epollEventArray.events(i3);
            AbstractEpollChannel abstractEpollChannel = this.channels.get(n7);
            if (abstractEpollChannel != null) {
                AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)abstractEpollChannel.unsafe();
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollOutReady();
                }
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollInReady();
                }
                if ((l2 & (long)Native.EPOLLRDHUP) == 0L) continue;
                abstractEpollChannel$AbstractEpollUnsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), n7);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cleanup() {
        try {
            try {
                this.epollFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the epoll fd.", iOException);
            }
            try {
                this.eventFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the event fd.", iOException);
            }
            try {
                this.timerFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the timer fd.", iOException);
            }
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    static /* synthetic */ int access$000(EpollEventLoop epollEventLoop) {
        return epollEventLoop.epollWaitNow();
    }

    static {
        Epoll.ensureAvailability();
    }
}

