/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.unix.Buffer;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int length;

    EpollEventArray(int n4) {
        if (n4 < 1) {
            throw new IllegalArgumentException("length must be >= 1 but was " + n4);
        }
        this.length = n4;
        this.memory = Buffer.allocateDirectWithNativeOrder(EpollEventArray.calculateBufferCapacity(n4));
        this.memoryAddress = Buffer.memoryAddress(this.memory);
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int length() {
        return this.length;
    }

    void increase() {
        this.length <<= 1;
        ByteBuffer byteBuffer = Buffer.allocateDirectWithNativeOrder(EpollEventArray.calculateBufferCapacity(this.length));
        Buffer.free(this.memory);
        this.memory = byteBuffer;
        this.memoryAddress = Buffer.memoryAddress(byteBuffer);
    }

    void free() {
        Buffer.free(this.memory);
        this.memoryAddress = 0L;
    }

    int events(int n4) {
        return this.getInt(n4, 0);
    }

    int fd(int n4) {
        return this.getInt(n4, EPOLL_DATA_OFFSET);
    }

    private int getInt(int n4, int n7) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getInt(this.memoryAddress + (long)(n4 * EPOLL_EVENT_SIZE) + (long)n7);
        }
        return this.memory.getInt(n4 * EPOLL_EVENT_SIZE + n7);
    }

    private static int calculateBufferCapacity(int n4) {
        return n4 * EPOLL_EVENT_SIZE;
    }
}

