/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.AddressedEnvelope;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.DefaultAddressedEnvelope;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDatagramChannel$EpollDatagramChannelUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoop;
import io.grpc.netty.shaded.io.netty.channel.epoll.LinuxSocket;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray;
import io.grpc.netty.shaded.io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.socket.DatagramChannel;
import io.grpc.netty.shaded.io.netty.channel.socket.DatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.socket.InternetProtocolFamily;
import io.grpc.netty.shaded.io.netty.channel.unix.IovArray;
import io.grpc.netty.shaded.io.netty.channel.unix.Socket;
import io.grpc.netty.shaded.io.netty.channel.unix.UnixChannelUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final EpollDatagramChannelConfig config = new EpollDatagramChannelConfig(this);
    private volatile boolean connected;

    public EpollDatagramChannel() {
        this((InternetProtocolFamily)null);
    }

    public EpollDatagramChannel(InternetProtocolFamily internetProtocolFamily) {
        this(internetProtocolFamily == null ? LinuxSocket.newSocketDgram(Socket.isIPv6Preferred()) : LinuxSocket.newSocketDgram(internetProtocolFamily == InternetProtocolFamily.IPv6));
    }

    public EpollDatagramChannel(int n4) {
        this(new LinuxSocket(n4));
    }

    private EpollDatagramChannel(LinuxSocket linuxSocket) {
        super(null, linuxSocket, true);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.joinGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (IOException iOException) {
            channelPromise.setFailure(iOException);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        try {
            this.socket.joinGroup(inetAddress, networkInterface, inetAddress2);
            channelPromise.setSuccess();
        }
        catch (IOException iOException) {
            channelPromise.setFailure(iOException);
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (IOException iOException) {
            channelPromise.setFailure(iOException);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        try {
            this.socket.leaveGroup(inetAddress, networkInterface, inetAddress2);
            channelPromise.setSuccess();
        }
        catch (IOException iOException) {
            channelPromise.setFailure(iOException);
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (inetAddress2 == null) {
            throw new NullPointerException("sourceToBlock");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    protected AbstractEpollChannel$AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannel$EpollDatagramChannelUnsafe(this);
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress;
        if (socketAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && inetSocketAddress.getAddress() instanceof Inet4Address && Socket.isIPv6Preferred()) {
            socketAddress = new InetSocketAddress(LinuxSocket.INET6_ANY, inetSocketAddress.getPort());
        }
        super.doBind(socketAddress);
        this.active = true;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        block2: while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                this.clearFlag(Native.EPOLLOUT);
                break;
            }
            try {
                int n4;
                if (Native.IS_SUPPORTING_SENDMMSG && channelOutboundBuffer.size() > 1) {
                    NativeDatagramPacketArray nativeDatagramPacketArray = ((EpollEventLoop)this.eventLoop()).cleanDatagramPacketArray();
                    channelOutboundBuffer.forEachFlushedMessage(nativeDatagramPacketArray);
                    n4 = nativeDatagramPacketArray.count();
                    if (n4 >= 1) {
                        int n7 = 0;
                        NativeDatagramPacketArray$NativeDatagramPacket[] nativeDatagramPacketArray$NativeDatagramPacketArray = nativeDatagramPacketArray.packets();
                        while (true) {
                            if (n4 <= 0) continue block2;
                            int n8 = this.socket.sendmmsg(nativeDatagramPacketArray$NativeDatagramPacketArray, n7, n4);
                            if (n8 == 0) {
                                this.setFlag(Native.EPOLLOUT);
                                return;
                            }
                            for (int i3 = 0; i3 < n8; ++i3) {
                                channelOutboundBuffer.remove();
                            }
                            n4 -= n8;
                            n7 += n8;
                        }
                    }
                }
                boolean bl3 = false;
                for (n4 = this.config().getWriteSpinCount(); n4 > 0; --n4) {
                    if (!this.doWriteMessage(object)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                this.setFlag(Native.EPOLLOUT);
            }
            catch (IOException iOException) {
                channelOutboundBuffer.remove(iOException);
                continue;
            }
            break;
        }
    }

    private boolean doWriteMessage(Object object) {
        long l2;
        InetSocketAddress inetSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)addressedEnvelope.content();
            inetSocketAddress = (InetSocketAddress)addressedEnvelope.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            inetSocketAddress = null;
        }
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            return true;
        }
        if (byteBuf.hasMemoryAddress()) {
            long l10 = byteBuf.memoryAddress();
            l2 = inetSocketAddress == null ? (long)this.socket.writeAddress(l10, byteBuf.readerIndex(), byteBuf.writerIndex()) : (long)this.socket.sendToAddress(l10, byteBuf.readerIndex(), byteBuf.writerIndex(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else if (byteBuf.nioBufferCount() > 1) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
            iovArray.add(byteBuf);
            int n7 = iovArray.count();
            assert (n7 != 0);
            l2 = inetSocketAddress == null ? this.socket.writevAddresses(iovArray.memoryAddress(0), n7) : (long)this.socket.sendToAddresses(iovArray.memoryAddress(0), n7, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes());
            l2 = inetSocketAddress == null ? (long)this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit()) : (long)this.socket.sendTo(byteBuffer, byteBuffer.position(), byteBuffer.limit(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        return l2 > 0L;
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        AddressedEnvelope<ByteBuf, InetSocketAddress> addressedEnvelope;
        if (object instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf) ? new DatagramPacket(this.newDirectBuffer(datagramPacket, byteBuf), (InetSocketAddress)datagramPacket.recipient()) : object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope<ByteBuf, InetSocketAddress>)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof InetSocketAddress)) {
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf) ? new DefaultAddressedEnvelope<ByteBuf, InetSocketAddress>(this.newDirectBuffer(addressedEnvelope, byteBuf), (InetSocketAddress)addressedEnvelope.recipient()) : addressedEnvelope;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    @Override
    public EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    public void doDisconnect() {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    public void doClose() {
        super.doClose();
        this.connected = false;
    }
}

