/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDatagramChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.socket.DatagramPacket;
import io.grpc.netty.shaded.io.netty.channel.unix.DatagramSocketAddress;
import io.grpc.netty.shaded.io.netty.channel.unix.Errors;
import io.grpc.netty.shaded.io.netty.channel.unix.Errors$NativeIoException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

final class EpollDatagramChannel$EpollDatagramChannelUnsafe
extends AbstractEpollChannel$AbstractEpollUnsafe {
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ EpollDatagramChannel this$0;

    EpollDatagramChannel$EpollDatagramChannelUnsafe(EpollDatagramChannel epollDatagramChannel) {
        this.this$0 = epollDatagramChannel;
        super(epollDatagramChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void epollInReady() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        EpollDatagramChannelConfig epollDatagramChannelConfig = this.this$0.config();
        if (this.this$0.shouldBreakEpollInReady(epollDatagramChannelConfig)) {
            this.clearEpollIn0();
            return;
        }
        EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
        epollRecvByteAllocatorHandle.edgeTriggered(this.this$0.isFlagSet(Native.EPOLLET));
        ChannelPipeline channelPipeline = this.this$0.pipeline();
        ByteBufAllocator byteBufAllocator = epollDatagramChannelConfig.getAllocator();
        epollRecvByteAllocatorHandle.reset(epollDatagramChannelConfig);
        this.epollInBefore();
        Throwable throwable = null;
        try {
            ReferenceCounted referenceCounted = null;
            try {
                boolean bl3 = this.this$0.isConnected();
                do {
                    DatagramPacket datagramPacket;
                    Object object;
                    referenceCounted = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                    epollRecvByteAllocatorHandle.attemptedBytesRead(((ByteBuf)referenceCounted).writableBytes());
                    if (bl3) {
                        try {
                            epollRecvByteAllocatorHandle.lastBytesRead(this.this$0.doReadBytes((ByteBuf)referenceCounted));
                        }
                        catch (Errors$NativeIoException errors$NativeIoException) {
                            if (errors$NativeIoException.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
                                object = new PortUnreachableException(errors$NativeIoException.getMessage());
                                ((Throwable)object).initCause(errors$NativeIoException);
                                throw object;
                            }
                            throw errors$NativeIoException;
                        }
                        if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                            referenceCounted.release();
                            referenceCounted = null;
                            break;
                        }
                        datagramPacket = new DatagramPacket((ByteBuf)referenceCounted, (InetSocketAddress)this.localAddress(), (InetSocketAddress)this.remoteAddress());
                    } else {
                        DatagramSocketAddress datagramSocketAddress;
                        if (((ByteBuf)referenceCounted).hasMemoryAddress()) {
                            datagramSocketAddress = this.this$0.socket.recvFromAddress(((ByteBuf)referenceCounted).memoryAddress(), ((ByteBuf)referenceCounted).writerIndex(), ((ByteBuf)referenceCounted).capacity());
                        } else {
                            object = ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).writerIndex(), ((ByteBuf)referenceCounted).writableBytes());
                            datagramSocketAddress = this.this$0.socket.recvFrom((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
                        }
                        if (datagramSocketAddress == null) {
                            epollRecvByteAllocatorHandle.lastBytesRead(-1);
                            referenceCounted.release();
                            referenceCounted = null;
                            break;
                        }
                        object = datagramSocketAddress.localAddress();
                        if (object == null) {
                            object = (InetSocketAddress)this.localAddress();
                        }
                        epollRecvByteAllocatorHandle.lastBytesRead(datagramSocketAddress.receivedAmount());
                        ((ByteBuf)referenceCounted).writerIndex(((ByteBuf)referenceCounted).writerIndex() + epollRecvByteAllocatorHandle.lastBytesRead());
                        datagramPacket = new DatagramPacket((ByteBuf)referenceCounted, (InetSocketAddress)object, datagramSocketAddress);
                    }
                    epollRecvByteAllocatorHandle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead(datagramPacket);
                    referenceCounted = null;
                } while (epollRecvByteAllocatorHandle.continueReading());
            }
            catch (Throwable throwable2) {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
                throwable = throwable2;
            }
            epollRecvByteAllocatorHandle.readComplete();
            channelPipeline.fireChannelReadComplete();
            if (throwable != null) {
                channelPipeline.fireExceptionCaught(throwable);
            }
        }
        finally {
            this.epollInFinally(epollDatagramChannelConfig);
        }
    }

    static {
        $assertionsDisabled = !EpollDatagramChannel.class.desiredAssertionStatus();
    }
}

