/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.DefaultFileRegion;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$1;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$2;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$3;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$4;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$5;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$6;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$7;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollSocketWritableByteChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$EpollStreamUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceFdTask;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInChannelTask;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInTask;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceOutTask;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoop;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollMode;
import io.grpc.netty.shaded.io.netty.channel.epoll.LinuxSocket;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.socket.DuplexChannel;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.channel.unix.IovArray;
import io.grpc.netty.shaded.io.netty.channel.unix.UnixChannelUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private final Runnable flushTask = new AbstractEpollStreamChannel$1(this);
    private volatile Queue<AbstractEpollStreamChannel$SpliceInTask> spliceQueue;
    private FileDescriptor pipeIn;
    private FileDescriptor pipeOut;
    private WritableByteChannel byteChannel;

    protected AbstractEpollStreamChannel(Channel channel, int n4) {
        this(channel, new LinuxSocket(n4));
    }

    protected AbstractEpollStreamChannel(int n4) {
        this(new LinuxSocket(n4));
    }

    AbstractEpollStreamChannel(LinuxSocket linuxSocket) {
        this(linuxSocket, AbstractEpollStreamChannel.isSoErrorZero(linuxSocket));
    }

    AbstractEpollStreamChannel(Channel channel, LinuxSocket linuxSocket) {
        super(channel, linuxSocket, true);
        this.flags |= Native.EPOLLRDHUP;
    }

    AbstractEpollStreamChannel(Channel channel, LinuxSocket linuxSocket, SocketAddress socketAddress) {
        super(channel, linuxSocket, socketAddress);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(LinuxSocket linuxSocket, boolean bl3) {
        super(null, linuxSocket, bl3);
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel$AbstractEpollUnsafe newUnsafe() {
        return new AbstractEpollStreamChannel$EpollStreamUnsafe(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n4) {
        return this.spliceTo(abstractEpollStreamChannel, n4, this.newPromise());
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n4, ChannelPromise channelPromise) {
        if (abstractEpollStreamChannel.eventLoop() != this.eventLoop()) {
            throw new IllegalArgumentException("EventLoops are not the same.");
        }
        ObjectUtil.checkPositiveOrZero(n4, "len");
        if (abstractEpollStreamChannel.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED || this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(new ClosedChannelException());
        } else {
            this.addToSpliceQueue(new AbstractEpollStreamChannel$SpliceInChannelTask(this, abstractEpollStreamChannel, n4, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n4, int n7) {
        return this.spliceTo(fileDescriptor, n4, n7, this.newPromise());
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n4, int n7, ChannelPromise channelPromise) {
        ObjectUtil.checkPositiveOrZero(n7, "len");
        ObjectUtil.checkPositiveOrZero(n4, "offset");
        if (this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(new ClosedChannelException());
        } else {
            this.addToSpliceQueue(new AbstractEpollStreamChannel$SpliceFdTask(this, fileDescriptor, n4, n7, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    private void failSpliceIfClosed(ChannelPromise channelPromise) {
        if (!this.isOpen() && channelPromise.tryFailure(new ClosedChannelException())) {
            this.eventLoop().execute(new AbstractEpollStreamChannel$2(this));
        }
    }

    private int writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (byteBuf.hasMemoryAddress() || byteBuf.nioBufferCount() == 1) {
            return this.doWriteBytes(channelOutboundBuffer, byteBuf);
        }
        ByteBuffer[] byteBufferArray = byteBuf.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n4, this.config().getMaxBytesPerGatheringWrite());
    }

    private void adjustMaxBytesPerGatheringWrite(long l2, long l10, long l11) {
        if (l2 == l10) {
            if (l2 << 1 > l11) {
                this.config().setMaxBytesPerGatheringWrite(l2 << 1);
            }
        } else if (l2 > 4096L && l10 < l2 >>> 1) {
            this.config().setMaxBytesPerGatheringWrite(l2 >>> 1);
        }
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray) {
        long l2 = iovArray.size();
        assert (l2 != 0L);
        int n4 = iovArray.count();
        assert (n4 != 0);
        long l10 = this.socket.writevAddresses(iovArray.memoryAddress(0), n4);
        if (l10 > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l2, l10, iovArray.maxBytes());
            channelOutboundBuffer.removeBytes(l10);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n4, long l2, long l10) {
        long l11;
        assert (l2 != 0L);
        if (l2 > l10) {
            l2 = l10;
        }
        if ((l11 = this.socket.writev(byteBufferArray, 0, n4, l2)) > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l2, l11, l10);
            channelOutboundBuffer.removeBytes(l11);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeDefaultFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion) {
        long l2;
        long l10 = defaultFileRegion.transferred();
        if (l10 >= (l2 = defaultFileRegion.count())) {
            channelOutboundBuffer.remove();
            return 0;
        }
        long l11 = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), l10, l2 - l10);
        if (l11 > 0L) {
            channelOutboundBuffer.progress(l11);
            if (defaultFileRegion.transferred() >= l2) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        if (l11 == 0L) {
            this.validateFileRegion(defaultFileRegion, l10);
        }
        return Integer.MAX_VALUE;
    }

    private int writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, FileRegion fileRegion) {
        long l2;
        if (fileRegion.transferred() >= fileRegion.count()) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new AbstractEpollStreamChannel$EpollSocketWritableByteChannel(this);
        }
        if ((l2 = fileRegion.transferTo(this.byteChannel, fileRegion.transferred())) > 0L) {
            channelOutboundBuffer.progress(l2);
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        int n4 = this.config().getWriteSpinCount();
        do {
            int n7;
            if ((n7 = channelOutboundBuffer.size()) > 1 && channelOutboundBuffer.current() instanceof ByteBuf) {
                n4 -= this.doWriteMultiple(channelOutboundBuffer);
                continue;
            }
            if (n7 == 0) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            n4 -= this.doWriteSingle(channelOutboundBuffer);
        } while (n4 > 0);
        if (n4 == 0) {
            this.clearFlag(Native.EPOLLOUT);
            this.eventLoop().execute(this.flushTask);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            return this.writeBytes(channelOutboundBuffer, (ByteBuf)object);
        }
        if (object instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(channelOutboundBuffer, (DefaultFileRegion)object);
        }
        if (object instanceof FileRegion) {
            return this.writeFileRegion(channelOutboundBuffer, (FileRegion)object);
        }
        if (object instanceof AbstractEpollStreamChannel$SpliceOutTask) {
            if (!((AbstractEpollStreamChannel$SpliceOutTask)object).spliceOut()) {
                return Integer.MAX_VALUE;
            }
            channelOutboundBuffer.remove();
            return 1;
        }
        throw new Error();
    }

    private int doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer) {
        long l2 = this.config().getMaxBytesPerGatheringWrite();
        IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
        iovArray.maxBytes(l2);
        channelOutboundBuffer.forEachFlushedMessage(iovArray);
        if (iovArray.count() >= 1) {
            return this.writeBytesMultiple(channelOutboundBuffer, iovArray);
        }
        channelOutboundBuffer.removeBytes(0L);
        return 0;
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof FileRegion || object instanceof AbstractEpollStreamChannel$SpliceOutTask) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    @Override
    public final void doShutdownOutput() {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdown(true, false);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            ((AbstractChannel$AbstractUnsafe)this.unsafe()).shutdownOutput(channelPromise);
        } else {
            eventLoop.execute(new AbstractEpollStreamChannel$3(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        Executor executor = ((AbstractEpollStreamChannel$EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new AbstractEpollStreamChannel$4(this, channelPromise));
        } else {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.shutdownInput0(channelPromise);
            } else {
                eventLoop.execute(new AbstractEpollStreamChannel$5(this, channelPromise));
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new AbstractEpollStreamChannel$6(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutputDone(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            AbstractEpollStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new AbstractEpollStreamChannel$7(this, channelFuture, channelPromise));
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    @Override
    public void doClose() {
        try {
            super.doClose();
        }
        finally {
            AbstractEpollStreamChannel.safeClosePipe(this.pipeIn);
            AbstractEpollStreamChannel.safeClosePipe(this.pipeOut);
            this.clearSpliceQueue();
        }
    }

    private void clearSpliceQueue() {
        AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask;
        Queue<AbstractEpollStreamChannel$SpliceInTask> queue = this.spliceQueue;
        if (queue == null) {
            return;
        }
        ClosedChannelException closedChannelException = null;
        while ((abstractEpollStreamChannel$SpliceInTask = queue.poll()) != null) {
            if (closedChannelException == null) {
                closedChannelException = new ClosedChannelException();
            }
            abstractEpollStreamChannel$SpliceInTask.promise.tryFailure(closedChannelException);
        }
    }

    private static void safeClosePipe(FileDescriptor fileDescriptor) {
        block3: {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException iOException) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Error while closing a pipe", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSpliceQueue(AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask) {
        Queue<AbstractEpollStreamChannel$SpliceInTask> queue = this.spliceQueue;
        if (queue == null) {
            AbstractEpollStreamChannel abstractEpollStreamChannel = this;
            synchronized (abstractEpollStreamChannel) {
                queue = this.spliceQueue;
                if (queue == null) {
                    this.spliceQueue = queue = PlatformDependent.newMpscQueue();
                }
            }
        }
        queue.add(abstractEpollStreamChannel$SpliceInTask);
    }

    static /* synthetic */ void access$000(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        abstractEpollStreamChannel.clearSpliceQueue();
    }

    static /* synthetic */ void access$100(AbstractEpollStreamChannel abstractEpollStreamChannel, ChannelPromise channelPromise) {
        abstractEpollStreamChannel.shutdownInput0(channelPromise);
    }

    static /* synthetic */ void access$200(AbstractEpollStreamChannel abstractEpollStreamChannel, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        abstractEpollStreamChannel.shutdownOutputDone(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$300(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        AbstractEpollStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
    }

    static /* synthetic */ Queue access$400(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.spliceQueue;
    }

    static /* synthetic */ FileDescriptor access$500(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.pipeOut;
    }

    static /* synthetic */ FileDescriptor access$602(AbstractEpollStreamChannel abstractEpollStreamChannel, FileDescriptor fileDescriptor) {
        abstractEpollStreamChannel.pipeIn = fileDescriptor;
        return abstractEpollStreamChannel.pipeIn;
    }

    static /* synthetic */ FileDescriptor access$502(AbstractEpollStreamChannel abstractEpollStreamChannel, FileDescriptor fileDescriptor) {
        abstractEpollStreamChannel.pipeOut = fileDescriptor;
        return abstractEpollStreamChannel.pipeOut;
    }

    static /* synthetic */ FileDescriptor access$600(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        return abstractEpollStreamChannel.pipeIn;
    }

    static /* synthetic */ void access$700(FileDescriptor fileDescriptor) {
        AbstractEpollStreamChannel.safeClosePipe(fileDescriptor);
    }
}

