/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$1;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$2;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoop;
import io.grpc.netty.shaded.io.netty.channel.epoll.LinuxSocket;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.socket.SocketChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.unix.FileDescriptor;
import io.grpc.netty.shaded.io.netty.channel.unix.Socket;
import io.grpc.netty.shaded.io.netty.channel.unix.UnixChannel;
import io.grpc.netty.shaded.io.netty.channel.unix.UnixChannelUtil;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ScheduledFuture;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    final LinuxSocket socket;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;
    protected int flags = Native.EPOLLET;
    boolean inputClosedSeenErrorOnRead;
    boolean epollInReadyRunnablePending;
    protected volatile boolean active;

    AbstractEpollChannel(LinuxSocket linuxSocket) {
        this(null, linuxSocket, false);
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, boolean bl3) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(linuxSocket, "fd");
        this.active = bl3;
        if (bl3) {
            this.local = linuxSocket.localAddress();
            this.remote = linuxSocket.remoteAddress();
        }
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, SocketAddress socketAddress) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(linuxSocket, "fd");
        this.active = true;
        this.remote = socketAddress;
        this.local = linuxSocket.localAddress();
    }

    static boolean isSoErrorZero(Socket socket) {
        try {
            return socket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    void setFlag(int n4) {
        if (!this.isFlagSet(n4)) {
            this.flags |= n4;
            this.modifyEvents();
        }
    }

    void clearFlag(int n4) {
        if (this.isFlagSet(n4)) {
            this.flags &= ~n4;
            this.modifyEvents();
        }
    }

    boolean isFlagSet(int n4) {
        return (this.flags & n4) != 0;
    }

    @Override
    public final FileDescriptor fd() {
        return this.socket;
    }

    @Override
    public abstract EpollChannelConfig config();

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            ScheduledFuture<?> scheduledFuture;
            ChannelPromise channelPromise = this.connectPromise;
            if (channelPromise != null) {
                channelPromise.tryFailure(new ClosedChannelException());
                this.connectPromise = null;
            }
            if ((scheduledFuture = this.connectTimeoutFuture) != null) {
                scheduledFuture.cancel(false);
                this.connectTimeoutFuture = null;
            }
            if (this.isRegistered()) {
                EventLoop eventLoop = this.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    eventLoop.execute(new AbstractEpollChannel$1(this));
                }
            }
        }
        finally {
            this.socket.close();
        }
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }

    @Override
    public void doDeregister() {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    @Override
    public final void doBeginRead() {
        AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe();
        abstractEpollChannel$AbstractEpollUnsafe.readPending = true;
        this.setFlag(Native.EPOLLIN);
        if (abstractEpollChannel$AbstractEpollUnsafe.maybeMoreDataToRead) {
            abstractEpollChannel$AbstractEpollUnsafe.executeEpollInReadyRunnable(this.config());
        }
    }

    final boolean shouldBreakEpollInReady(ChannelConfig channelConfig) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractEpollChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        if (channelConfig instanceof EpollDomainSocketChannelConfig) {
            return ((EpollDomainSocketChannelConfig)channelConfig).isAllowHalfClosure();
        }
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    final void clearEpollIn() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe();
            if (eventLoop.inEventLoop()) {
                abstractEpollChannel$AbstractEpollUnsafe.clearEpollIn0();
            } else {
                eventLoop.execute(new AbstractEpollChannel$2(this, abstractEpollChannel$AbstractEpollUnsafe));
            }
        } else {
            this.flags &= ~Native.EPOLLIN;
        }
    }

    private void modifyEvents() {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    @Override
    public void doRegister() {
        this.epollInReadyRunnablePending = false;
        ((EpollEventLoop)this.eventLoop()).add(this);
    }

    @Override
    protected abstract AbstractEpollChannel$AbstractEpollUnsafe newUnsafe();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        return this.newDirectBuffer(byteBuf, byteBuf);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            ReferenceCountUtil.release(object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n4);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n4);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n4) {
        ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n4);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n4;
        int n7 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n4 = this.socket.readAddress(byteBuf.memoryAddress(), n7, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n7, byteBuf.writableBytes());
            n4 = this.socket.read(byteBuffer, byteBuffer.position(), byteBuffer.limit());
        }
        if (n4 > 0) {
            byteBuf.writerIndex(n7 + n4);
        }
        return n4;
    }

    protected final int doWriteBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        if (byteBuf.hasMemoryAddress()) {
            int n4 = this.socket.writeAddress(byteBuf.memoryAddress(), byteBuf.readerIndex(), byteBuf.writerIndex());
            if (n4 > 0) {
                channelOutboundBuffer.removeBytes(n4);
                return 1;
            }
        } else {
            ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()) : byteBuf.nioBuffer();
            int n7 = this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit());
            if (n7 > 0) {
                byteBuffer.position(byteBuffer.position() + n7);
                channelOutboundBuffer.removeBytes(n7);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress);
        }
        this.socket.bind(socketAddress);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl3;
        InetSocketAddress inetSocketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            AbstractEpollChannel.checkResolvable(inetSocketAddress);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (socketAddress2 != null) {
            this.socket.bind(socketAddress2);
        }
        if (bl3 = this.doConnect0(socketAddress)) {
            this.remote = inetSocketAddress == null ? socketAddress : UnixChannelUtil.computeRemoteAddr(inetSocketAddress, this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect0(SocketAddress socketAddress) {
        boolean bl3 = false;
        try {
            boolean bl4 = this.socket.connect(socketAddress);
            if (!bl4) {
                this.setFlag(Native.EPOLLOUT);
            }
            bl3 = true;
            boolean bl5 = bl4;
            return bl5;
        }
        finally {
            if (!bl3) {
                this.doClose();
            }
        }
    }

    @Override
    public SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.remote;
    }

    static /* synthetic */ boolean access$000(ChannelConfig channelConfig) {
        return AbstractEpollChannel.isAllowHalfClosure(channelConfig);
    }

    static /* synthetic */ ChannelPromise access$100(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$102(AbstractEpollChannel abstractEpollChannel, ChannelPromise channelPromise) {
        abstractEpollChannel.connectPromise = channelPromise;
        return abstractEpollChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$202(AbstractEpollChannel abstractEpollChannel, SocketAddress socketAddress) {
        abstractEpollChannel.requestedRemoteAddress = socketAddress;
        return abstractEpollChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$302(AbstractEpollChannel abstractEpollChannel, ScheduledFuture scheduledFuture) {
        abstractEpollChannel.connectTimeoutFuture = scheduledFuture;
        return abstractEpollChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$300(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$200(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.requestedRemoteAddress;
    }

    static /* synthetic */ SocketAddress access$402(AbstractEpollChannel abstractEpollChannel, SocketAddress socketAddress) {
        abstractEpollChannel.remote = socketAddress;
        return abstractEpollChannel.remote;
    }
}

