/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.epoll;

import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe$1;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe$2;
import io.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe$3;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.grpc.netty.shaded.io.netty.channel.epoll.Native;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.grpc.netty.shaded.io.netty.channel.unix.UnixChannelUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEpollChannel$AbstractEpollUnsafe
extends AbstractChannel$AbstractUnsafe {
    boolean readPending;
    boolean maybeMoreDataToRead;
    private EpollRecvByteAllocatorHandle allocHandle;
    private final Runnable epollInReadyRunnable;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractEpollChannel this$0;

    protected AbstractEpollChannel$AbstractEpollUnsafe(AbstractEpollChannel abstractEpollChannel) {
        this.this$0 = abstractEpollChannel;
        super(abstractEpollChannel);
        this.epollInReadyRunnable = new AbstractEpollChannel$AbstractEpollUnsafe$1(this);
    }

    abstract void epollInReady();

    final void epollInBefore() {
        this.maybeMoreDataToRead = false;
    }

    final void epollInFinally(ChannelConfig channelConfig) {
        this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
        if (this.allocHandle.isReceivedRdHup() || this.readPending && this.maybeMoreDataToRead) {
            this.executeEpollInReadyRunnable(channelConfig);
        } else if (!this.readPending && !channelConfig.isAutoRead()) {
            this.this$0.clearEpollIn();
        }
    }

    final void executeEpollInReadyRunnable(ChannelConfig channelConfig) {
        if (this.this$0.epollInReadyRunnablePending || !this.this$0.isActive() || this.this$0.shouldBreakEpollInReady(channelConfig)) {
            return;
        }
        this.this$0.epollInReadyRunnablePending = true;
        this.this$0.eventLoop().execute(this.epollInReadyRunnable);
    }

    final void epollRdHupReady() {
        this.recvBufAllocHandle().receivedRdHup();
        if (this.this$0.isActive()) {
            this.epollInReady();
        } else {
            this.shutdownInput(true);
        }
        this.clearEpollRdHup();
    }

    private void clearEpollRdHup() {
        try {
            this.this$0.clearFlag(Native.EPOLLRDHUP);
        }
        catch (IOException iOException) {
            this.this$0.pipeline().fireExceptionCaught(iOException);
            this.close(this.voidPromise());
        }
    }

    void shutdownInput(boolean bl3) {
        if (!this.this$0.socket.isInputShutdown()) {
            if (AbstractEpollChannel.access$000(this.this$0.config())) {
                try {
                    this.this$0.socket.shutdown(true, false);
                }
                catch (IOException iOException) {
                    this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    // empty catch block
                }
                this.this$0.clearEpollIn();
                this.this$0.pipeline().fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.close(this.voidPromise());
            }
        } else if (!bl3) {
            this.this$0.inputClosedSeenErrorOnRead = true;
            this.this$0.pipeline().fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void fireEventAndClose(Object object) {
        this.this$0.pipeline().fireUserEventTriggered(object);
        this.close(this.voidPromise());
    }

    @Override
    public EpollRecvByteAllocatorHandle recvBufAllocHandle() {
        if (this.allocHandle == null) {
            this.allocHandle = this.newEpollHandle((RecvByteBufAllocator$ExtendedHandle)super.recvBufAllocHandle());
        }
        return this.allocHandle;
    }

    EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator$ExtendedHandle recvByteBufAllocator$ExtendedHandle) {
        return new EpollRecvByteAllocatorHandle(recvByteBufAllocator$ExtendedHandle);
    }

    @Override
    public final void flush0() {
        if (!this.this$0.isFlagSet(Native.EPOLLOUT)) {
            super.flush0();
        }
    }

    final void epollOutReady() {
        if (AbstractEpollChannel.access$100(this.this$0) != null) {
            this.finishConnect();
        } else if (!this.this$0.socket.isOutputShutdown()) {
            super.flush0();
        }
    }

    protected final void clearEpollIn0() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        try {
            this.readPending = false;
            this.this$0.clearFlag(Native.EPOLLIN);
        }
        catch (IOException iOException) {
            this.this$0.pipeline().fireExceptionCaught(iOException);
            this.this$0.unsafe().close(this.this$0.unsafe().voidPromise());
        }
    }

    @Override
    public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        try {
            if (AbstractEpollChannel.access$100(this.this$0) != null) {
                throw new ConnectionPendingException();
            }
            boolean bl3 = this.this$0.isActive();
            if (this.this$0.doConnect(socketAddress, socketAddress2)) {
                this.fulfillConnectPromise(channelPromise, bl3);
            } else {
                AbstractEpollChannel.access$102(this.this$0, channelPromise);
                AbstractEpollChannel.access$202(this.this$0, socketAddress);
                int n4 = this.this$0.config().getConnectTimeoutMillis();
                if (n4 > 0) {
                    AbstractEpollChannel.access$302(this.this$0, this.this$0.eventLoop().schedule(new AbstractEpollChannel$AbstractEpollUnsafe$2(this, socketAddress), (long)n4, TimeUnit.MILLISECONDS));
                }
                channelPromise.addListener(new AbstractEpollChannel$AbstractEpollUnsafe$3(this));
            }
        }
        catch (Throwable throwable) {
            this.closeIfClosed();
            channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl3) {
        if (channelPromise == null) {
            return;
        }
        this.this$0.active = true;
        boolean bl4 = this.this$0.isActive();
        boolean bl5 = channelPromise.trySuccess();
        if (!bl3 && bl4) {
            this.this$0.pipeline().fireChannelActive();
        }
        if (!bl5) {
            this.close(this.voidPromise());
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
        if (channelPromise == null) {
            return;
        }
        channelPromise.tryFailure(throwable);
        this.closeIfClosed();
    }

    private void finishConnect() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        boolean bl3 = false;
        try {
            boolean bl4 = this.this$0.isActive();
            if (!this.doFinishConnect()) {
                bl3 = true;
                return;
            }
            this.fulfillConnectPromise(AbstractEpollChannel.access$100(this.this$0), bl4);
        }
        catch (Throwable throwable) {
            this.fulfillConnectPromise(AbstractEpollChannel.access$100(this.this$0), this.annotateConnectException(throwable, AbstractEpollChannel.access$200(this.this$0)));
        }
        finally {
            if (!bl3) {
                if (AbstractEpollChannel.access$300(this.this$0) != null) {
                    AbstractEpollChannel.access$300(this.this$0).cancel(false);
                }
                AbstractEpollChannel.access$102(this.this$0, null);
            }
        }
    }

    private boolean doFinishConnect() {
        if (this.this$0.socket.finishConnect()) {
            this.this$0.clearFlag(Native.EPOLLOUT);
            if (AbstractEpollChannel.access$200(this.this$0) instanceof InetSocketAddress) {
                AbstractEpollChannel.access$402(this.this$0, UnixChannelUtil.computeRemoteAddr((InetSocketAddress)AbstractEpollChannel.access$200(this.this$0), this.this$0.socket.remoteAddress()));
            }
            AbstractEpollChannel.access$202(this.this$0, null);
            return true;
        }
        this.this$0.setFlag(Native.EPOLLOUT);
        return false;
    }

    static {
        $assertionsDisabled = !AbstractEpollChannel.class.desiredAssertionStatus();
    }
}

