/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.embedded;

import io.grpc.netty.shaded.io.netty.channel.AbstractChannel;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.Channel$Unsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelId;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.DefaultChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.DefaultChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel$1;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel$2;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel$EmbeddedChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel$EmbeddedUnsafe;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel$State;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannelId;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedEventLoop;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedSocketAddress;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.RecyclableArrayList;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new EmbeddedChannel$1(this);
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private EmbeddedChannel$State state;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl3, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl3, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl3, boolean bl4, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl3, bl4, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl3, ChannelHandler ... channelHandlerArray) {
        this(channelId, true, bl3, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl3, boolean bl4, ChannelHandler ... channelHandlerArray) {
        this(null, channelId, bl3, bl4, channelHandlerArray);
    }

    public EmbeddedChannel(Channel channel, ChannelId channelId, boolean bl3, boolean bl4, ChannelHandler ... channelHandlerArray) {
        super(channel, channelId);
        this.metadata = EmbeddedChannel.metadata(bl4);
        this.config = new DefaultChannelConfig(this);
        this.setup(bl3, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl3, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl3);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(true, channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl3) {
        return bl3 ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean bl3, ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new EmbeddedChannel$2(this, channelHandlerArray));
        if (bl3) {
            ChannelFuture channelFuture = this.loop.register(this);
            assert (channelFuture.isDone());
        }
    }

    public void register() {
        ChannelFuture channelFuture = this.loop.register(this);
        assert (channelFuture.isDone());
        Throwable throwable = channelFuture.cause();
        if (throwable != null) {
            PlatformDependent.throwException(throwable);
        }
    }

    @Override
    public final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannel$EmbeddedChannelPipeline(this, this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != EmbeddedChannel$State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == EmbeddedChannel$State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public <T> T readInbound() {
        Object object = EmbeddedChannel.poll(this.inboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readInbound() will handle the message from this point");
        }
        return (T)object;
    }

    public <T> T readOutbound() {
        Object object = EmbeddedChannel.poll(this.outboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readOutbound() will handle the message from this point.");
        }
        return (T)object;
    }

    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline channelPipeline = this.pipeline();
        for (Object object : objectArray) {
            channelPipeline.fireChannelRead(object);
        }
        this.flushInbound(false, this.voidPromise());
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public ChannelFuture writeOneInbound(Object object) {
        return this.writeOneInbound(object, this.newPromise());
    }

    public ChannelFuture writeOneInbound(Object object, ChannelPromise channelPromise) {
        if (this.checkOpen(true)) {
            this.pipeline().fireChannelRead(object);
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushInbound() {
        this.flushInbound(true, this.voidPromise());
        return this;
    }

    private ChannelFuture flushInbound(boolean bl3, ChannelPromise channelPromise) {
        if (this.checkOpen(bl3)) {
            this.pipeline().fireChannelReadComplete();
            this.runPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(objectArray.length);
        try {
            Object object;
            Object[] objectArray2 = objectArray;
            int n4 = objectArray2.length;
            for (int i3 = 0; i3 < n4 && (object = objectArray2[i3]) != null; ++i3) {
                recyclableArrayList.add(this.write(object));
            }
            this.flushOutbound0();
            int n7 = recyclableArrayList.size();
            for (n4 = 0; n4 < n7; ++n4) {
                ChannelFuture channelFuture = (ChannelFuture)recyclableArrayList.get(n4);
                if (channelFuture.isDone()) {
                    this.recordException(channelFuture);
                    continue;
                }
                channelFuture.addListener(this.recordExceptionListener);
            }
            this.checkException();
            n4 = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n4 != 0;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public ChannelFuture writeOneOutbound(Object object) {
        return this.writeOneOutbound(object, this.newPromise());
    }

    public ChannelFuture writeOneOutbound(Object object, ChannelPromise channelPromise) {
        if (this.checkOpen(true)) {
            return this.write(object, channelPromise);
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushOutbound() {
        if (this.checkOpen(true)) {
            this.flushOutbound0();
        }
        this.checkException(this.voidPromise());
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        this.flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl3) {
        this.close();
        try {
            this.checkException();
            boolean bl4 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl4;
        }
        finally {
            if (bl3) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl3) {
        this.runPendingTasks();
        if (bl3) {
            this.loop.cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        this.runPendingTasks();
        ChannelFuture channelFuture = super.close(channelPromise);
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = super.disconnect(channelPromise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return channelFuture;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.loop.runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    public long runScheduledPendingTasks() {
        try {
            return this.loop.runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
            return this.loop.nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    private ChannelFuture checkException(ChannelPromise channelPromise) {
        Throwable throwable = this.lastException;
        if (throwable != null) {
            this.lastException = null;
            if (channelPromise.isVoid()) {
                PlatformDependent.throwException(throwable);
            }
            return channelPromise.setFailure(throwable);
        }
        return channelPromise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean bl3) {
        if (!this.isOpen()) {
            if (bl3) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    public boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    public SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    public void doRegister() {
        this.state = EmbeddedChannel$State.ACTIVE;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
    }

    @Override
    public void doDisconnect() {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    public void doClose() {
        this.state = EmbeddedChannel$State.CLOSED;
    }

    @Override
    public void doBeginRead() {
    }

    @Override
    public AbstractChannel$AbstractUnsafe newUnsafe() {
        return new EmbeddedChannel$EmbeddedUnsafe(this, null);
    }

    @Override
    public Channel$Unsafe unsafe() {
        return ((EmbeddedChannel$EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.handleOutboundMessage(object);
            channelOutboundBuffer.remove();
        }
    }

    protected void handleOutboundMessage(Object object) {
        this.outboundMessages().add(object);
    }

    protected void handleInboundMessage(Object object) {
        this.inboundMessages().add(object);
    }

    static /* synthetic */ void access$000(EmbeddedChannel embeddedChannel, ChannelFuture channelFuture) {
        embeddedChannel.recordException(channelFuture);
    }

    static /* synthetic */ void access$200(EmbeddedChannel embeddedChannel, Throwable throwable) {
        embeddedChannel.recordException(throwable);
    }
}

