/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class WriteBufferWaterMark {
    private static final int DEFAULT_LOW_WATER_MARK = 32768;
    private static final int DEFAULT_HIGH_WATER_MARK = 65536;
    public static final WriteBufferWaterMark DEFAULT = new WriteBufferWaterMark(32768, 65536, false);
    private final int low;
    private final int high;

    public WriteBufferWaterMark(int n4, int n7) {
        this(n4, n7, true);
    }

    WriteBufferWaterMark(int n4, int n7, boolean bl3) {
        if (bl3) {
            ObjectUtil.checkPositiveOrZero(n4, "low");
            if (n7 < n4) {
                throw new IllegalArgumentException("write buffer's high water mark cannot be less than  low water mark (" + n4 + "): " + n7);
            }
        }
        this.low = n4;
        this.high = n7;
    }

    public int low() {
        return this.low;
    }

    public int high() {
        return this.high;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(55).append("WriteBufferWaterMark(low: ").append(this.low).append(", high: ").append(this.high).append(")");
        return stringBuilder.toString();
    }
}

