/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class PreferHeapByteBufAllocator
implements ByteBufAllocator {
    private final ByteBufAllocator allocator;

    public PreferHeapByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.allocator = ObjectUtil.checkNotNull(byteBufAllocator, "allocator");
    }

    @Override
    public ByteBuf buffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n4) {
        return this.allocator.heapBuffer(n4);
    }

    @Override
    public ByteBuf buffer(int n4, int n7) {
        return this.allocator.heapBuffer(n4, n7);
    }

    @Override
    public ByteBuf ioBuffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf ioBuffer(int n4) {
        return this.allocator.heapBuffer(n4);
    }

    @Override
    public ByteBuf ioBuffer(int n4, int n7) {
        return this.allocator.heapBuffer(n4, n7);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf heapBuffer(int n4) {
        return this.allocator.heapBuffer(n4);
    }

    @Override
    public ByteBuf heapBuffer(int n4, int n7) {
        return this.allocator.heapBuffer(n4, n7);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.allocator.directBuffer();
    }

    @Override
    public ByteBuf directBuffer(int n4) {
        return this.allocator.directBuffer(n4);
    }

    @Override
    public ByteBuf directBuffer(int n4, int n7) {
        return this.allocator.directBuffer(n4, n7);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n4) {
        return this.allocator.compositeHeapBuffer(n4);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n4) {
        return this.allocator.compositeHeapBuffer(n4);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.allocator.compositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n4) {
        return this.allocator.compositeDirectBuffer(n4);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.allocator.isDirectBufferPooled();
    }

    @Override
    public int calculateNewCapacity(int n4, int n7) {
        return this.allocator.calculateNewCapacity(n4, n7);
    }
}

