/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.PendingBytesTracker;
import io.grpc.netty.shaded.io.netty.channel.PendingWriteQueue$PendingWrite;
import io.grpc.netty.shaded.io.netty.channel.VoidChannelPromise;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.PromiseCombiner;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelHandlerContext ctx;
    private final PendingBytesTracker tracker;
    private PendingWriteQueue$PendingWrite head;
    private PendingWriteQueue$PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        this.tracker = PendingBytesTracker.newTracker(channelHandlerContext.channel());
        this.ctx = channelHandlerContext;
    }

    public boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.ctx.executor().inEventLoop());
        return this.bytes;
    }

    private int size(Object object) {
        int n4 = this.tracker.size(object);
        if (n4 < 0) {
            n4 = 0;
        }
        return n4 + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object object, ChannelPromise channelPromise) {
        assert (this.ctx.executor().inEventLoop());
        if (object == null) {
            throw new NullPointerException("msg");
        }
        if (channelPromise == null) {
            throw new NullPointerException("promise");
        }
        int n4 = this.size(object);
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = PendingWriteQueue$PendingWrite.newInstance(object, n4, channelPromise);
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = this.tail;
        if (pendingWriteQueue$PendingWrite2 == null) {
            this.tail = this.head = pendingWriteQueue$PendingWrite;
        } else {
            PendingWriteQueue$PendingWrite.access$002(pendingWriteQueue$PendingWrite2, pendingWriteQueue$PendingWrite);
            this.tail = pendingWriteQueue$PendingWrite;
        }
        ++this.size;
        this.bytes += (long)n4;
        this.tracker.incrementPendingOutboundBytes(PendingWriteQueue$PendingWrite.access$100(pendingWriteQueue$PendingWrite));
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.ctx.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner(this.ctx.executor());
        try {
            PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
            while (pendingWriteQueue$PendingWrite != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWriteQueue$PendingWrite != null) {
                    PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                    Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
                    ChannelPromise channelPromise2 = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                    this.recycle(pendingWriteQueue$PendingWrite, false);
                    if (!(channelPromise2 instanceof VoidChannelPromise)) {
                        promiseCombiner.add(channelPromise2);
                    }
                    this.ctx.write(object, channelPromise2);
                    pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
                }
                pendingWriteQueue$PendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public void removeAndFailAll(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        while (pendingWriteQueue$PendingWrite != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWriteQueue$PendingWrite != null) {
                PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
                ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                this.recycle(pendingWriteQueue$PendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
            }
            pendingWriteQueue$PendingWrite = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        PendingWriteQueue.safeFail(channelPromise, throwable);
        this.recycle(pendingWriteQueue$PendingWrite, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return this.ctx.write(object, channelPromise);
    }

    public ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return channelPromise;
    }

    public Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        return PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
    }

    private void recycle(PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite, boolean bl3) {
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
        long l2 = PendingWriteQueue$PendingWrite.access$100(pendingWriteQueue$PendingWrite);
        if (bl3) {
            if (pendingWriteQueue$PendingWrite2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWriteQueue$PendingWrite2;
                --this.size;
                this.bytes -= l2;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        PendingWriteQueue$PendingWrite.access$400(pendingWriteQueue$PendingWrite);
        this.tracker.decrementPendingOutboundBytes(l2);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }
}

