/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final File f;
    private final long position;
    private final long count;
    private long transferred;
    private FileChannel file;

    public DefaultFileRegion(FileChannel fileChannel, long l2, long l10) {
        if (fileChannel == null) {
            throw new NullPointerException("file");
        }
        ObjectUtil.checkPositiveOrZero(l2, "position");
        ObjectUtil.checkPositiveOrZero(l10, "count");
        this.file = fileChannel;
        this.position = l2;
        this.count = l10;
        this.f = null;
    }

    public DefaultFileRegion(File file, long l2, long l10) {
        if (file == null) {
            throw new NullPointerException("f");
        }
        ObjectUtil.checkPositiveOrZero(l2, "position");
        ObjectUtil.checkPositiveOrZero(l10, "count");
        this.position = l2;
        this.count = l10;
        this.f = file;
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() {
        if (!this.isOpen() && this.refCnt() > 0) {
            this.file = new RandomAccessFile(this.f, "r").getChannel();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    @Deprecated
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public long transferTo(WritableByteChannel writableByteChannel, long l2) {
        long l10 = this.count - l2;
        if (l10 < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position out of range: " + l2 + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (l10 == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long l11 = this.file.transferTo(this.position + l2, l10, writableByteChannel);
        if (l11 > 0L) {
            this.transferred += l11;
        } else if (l11 == 0L) {
            DefaultFileRegion.validate(this, l2);
        }
        return l11;
    }

    @Override
    public void deallocate() {
        block3: {
            FileChannel fileChannel = this.file;
            if (fileChannel == null) {
                return;
            }
            this.file = null;
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Failed to close a file.", iOException);
            }
        }
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object object) {
        return this;
    }

    static void validate(DefaultFileRegion defaultFileRegion, long l2) {
        long l10 = defaultFileRegion.count - l2;
        long l11 = defaultFileRegion.file.size();
        if (defaultFileRegion.position + l10 + l2 > l11) {
            throw new IOException("Underlying file size " + l11 + " smaller then requested count " + defaultFileRegion.count);
        }
    }
}

