/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelId;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.MacAddressUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID_LEN = 4;
    private static final int PROCESS_ID;
    private static final int SEQUENCE_LEN = 4;
    private static final int TIMESTAMP_LEN = 8;
    private static final int RANDOM_LEN = 4;
    private static final AtomicInteger nextSequence;
    private final byte[] data = new byte[MACHINE_ID.length + 4 + 4 + 8 + 4];
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId();
    }

    private static int defaultProcessId() {
        int n4;
        String string;
        Class<?> clazz;
        ClassLoader classLoader = null;
        try {
            classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
            Class<?> clazz2 = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            Method method = clazz2.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            Object object = method.invoke(null, EmptyArrays.EMPTY_OBJECTS);
            Method method2 = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            string = (String)method2.invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable throwable) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", throwable);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                Method method = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                string = method.invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable throwable2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", throwable2);
                string = "";
            }
        }
        int n7 = string.indexOf(64);
        if (n7 >= 0) {
            string = string.substring(0, n7);
        }
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n4 = -1;
        }
        if (n4 < 0) {
            n4 = PlatformDependent.threadLocalRandom().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", (Object)string, (Object)n4);
        }
        return n4;
    }

    private DefaultChannelId() {
        int n4 = 0;
        System.arraycopy(MACHINE_ID, 0, this.data, n4, MACHINE_ID.length);
        n4 += MACHINE_ID.length;
        n4 = this.writeInt(n4, PROCESS_ID);
        n4 = this.writeInt(n4, nextSequence.getAndIncrement());
        n4 = this.writeLong(n4, Long.reverse(System.nanoTime()) ^ System.currentTimeMillis());
        int n7 = PlatformDependent.threadLocalRandom().nextInt();
        n4 = this.writeInt(n4, n7);
        assert (n4 == this.data.length);
        this.hashCode = Arrays.hashCode(this.data);
    }

    private int writeInt(int n4, int n7) {
        this.data[n4++] = (byte)(n7 >>> 24);
        this.data[n4++] = (byte)(n7 >>> 16);
        this.data[n4++] = (byte)(n7 >>> 8);
        this.data[n4++] = (byte)n7;
        return n4;
    }

    private int writeLong(int n4, long l2) {
        this.data[n4++] = (byte)(l2 >>> 56);
        this.data[n4++] = (byte)(l2 >>> 48);
        this.data[n4++] = (byte)(l2 >>> 40);
        this.data[n4++] = (byte)(l2 >>> 32);
        this.data[n4++] = (byte)(l2 >>> 24);
        this.data[n4++] = (byte)(l2 >>> 16);
        this.data[n4++] = (byte)(l2 >>> 8);
        this.data[n4++] = (byte)l2;
        return n4;
    }

    @Override
    public String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump(this.data, this.data.length - 4, 4);
        }
        return string;
    }

    @Override
    public String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n4 = 0;
        n4 = this.appendHexDumpField(stringBuilder, n4, MACHINE_ID.length);
        n4 = this.appendHexDumpField(stringBuilder, n4, 4);
        n4 = this.appendHexDumpField(stringBuilder, n4, 4);
        n4 = this.appendHexDumpField(stringBuilder, n4, 8);
        n4 = this.appendHexDumpField(stringBuilder, n4, 4);
        assert (n4 == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n4, int n7) {
        stringBuilder.append(ByteBufUtil.hexDump(this.data, n4, n7));
        stringBuilder.append('-');
        return n4 += n7;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ChannelId channelId) {
        if (this == channelId) {
            return 0;
        }
        if (channelId instanceof DefaultChannelId) {
            byte[] byArray = ((DefaultChannelId)channelId).data;
            int n4 = this.data.length;
            int n7 = byArray.length;
            int n8 = Math.min(n4, n7);
            for (int i3 = 0; i3 < n8; ++i3) {
                byte by2 = this.data[i3];
                byte by3 = byArray[i3];
                if (by2 == by3) continue;
                return (by2 & 0xFF) - (by3 & 0xFF);
            }
            return n4 - n7;
        }
        return this.asLongText().compareTo(channelId.asLongText());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        DefaultChannelId defaultChannelId = (DefaultChannelId)object;
        return this.hashCode == defaultChannelId.hashCode && Arrays.equals(this.data, defaultChannelId.data);
    }

    public String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n4 = -1;
        String string = SystemPropertyUtil.get("io.grpc.netty.shaded.io.netty.processId");
        if (string != null) {
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n4 < 0) {
                n4 = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n4);
            }
        }
        if (n4 < 0) {
            n4 = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n4);
            }
        }
        PROCESS_ID = n4;
        byte[] byArray = null;
        String string2 = SystemPropertyUtil.get("io.grpc.netty.shaded.io.netty.machineId");
        if (string2 != null) {
            try {
                byArray = MacAddressUtil.parseMAC(string2);
            }
            catch (Exception exception) {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string2, (Object)exception);
            }
            if (byArray != null) {
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string2);
            }
        }
        if (byArray == null) {
            byArray = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress(byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

