/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufHolder;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$1;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$2;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$3;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$Entry;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelProgressivePromise;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.FileRegion;
import io.grpc.netty.shaded.io.netty.channel.VoidChannelPromise;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import io.grpc.netty.shaded.io.netty.util.internal.PromiseNotificationUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.transport.outboundBufferEntrySizeOverhead", 96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new ChannelOutboundBuffer$1();
    private final Channel channel;
    private ChannelOutboundBuffer$Entry flushedEntry;
    private ChannelOutboundBuffer$Entry unflushedEntry;
    private ChannelOutboundBuffer$Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public void addMessage(Object object, int n4, ChannelPromise channelPromise) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = ChannelOutboundBuffer$Entry.newInstance(object, n4, ChannelOutboundBuffer.total(object), channelPromise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry2 = this.tailEntry;
            channelOutboundBuffer$Entry2.next = channelOutboundBuffer$Entry;
        }
        this.tailEntry = channelOutboundBuffer$Entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = channelOutboundBuffer$Entry;
        }
        this.incrementPendingOutboundBytes(channelOutboundBuffer$Entry.pendingSize, false);
    }

    public void addFlush() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry;
        if (channelOutboundBuffer$Entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = channelOutboundBuffer$Entry;
            }
            do {
                ++this.flushed;
                if (channelOutboundBuffer$Entry.promise.setUncancellable()) continue;
                int n4 = channelOutboundBuffer$Entry.cancel();
                this.decrementPendingOutboundBytes(n4, false, true);
            } while ((channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long l2) {
        this.incrementPendingOutboundBytes(l2, true);
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl3) {
        if (l2 == 0L) {
            return;
        }
        long l10 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l10 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl3);
        }
    }

    void decrementPendingOutboundBytes(long l2) {
        this.decrementPendingOutboundBytes(l2, true, true);
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl3, boolean bl4) {
        if (l2 == 0L) {
            return;
        }
        long l10 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (bl4 && l10 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl3);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return null;
        }
        return channelOutboundBuffer$Entry.msg;
    }

    public long currentProgress() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return 0L;
        }
        return channelOutboundBuffer$Entry.progress;
    }

    public void progress(long l2) {
        long l10;
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        assert (channelOutboundBuffer$Entry != null);
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        channelOutboundBuffer$Entry.progress = l10 = channelOutboundBuffer$Entry.progress + l2;
        if (channelPromise instanceof ChannelProgressivePromise) {
            ((ChannelProgressivePromise)channelPromise).tryProgress(l10, channelOutboundBuffer$Entry.total);
        }
    }

    public boolean remove() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n4 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n4, false, true);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    public boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl3) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n4 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n4, false, bl3);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    private void removeEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (channelOutboundBuffer$Entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = channelOutboundBuffer$Entry.next;
        }
    }

    public void removeBytes(long l2) {
        block5: {
            int n4;
            ByteBuf byteBuf;
            while (true) {
                Object object;
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l2 == 0L);
                    break block5;
                }
                byteBuf = (ByteBuf)object;
                n4 = byteBuf.readerIndex();
                int n7 = byteBuf.writerIndex() - n4;
                if ((long)n7 > l2) break;
                if (l2 != 0L) {
                    this.progress(n7);
                    l2 -= (long)n7;
                }
                this.remove();
            }
            if (l2 != 0L) {
                byteBuf.readerIndex(n4 + (int)l2);
                this.progress(l2);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n4 = this.nioBufferCount;
        if (n4 > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n4, null);
        }
    }

    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ByteBuffer[] nioBuffers(int n4, long l2) {
        assert (n4 > 0);
        assert (l2 > 0L);
        long l10 = 0L;
        int n7 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        while (this.isFlushedEntry(channelOutboundBuffer$Entry) && channelOutboundBuffer$Entry.msg instanceof ByteBuf) {
            if (!channelOutboundBuffer$Entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)channelOutboundBuffer$Entry.msg;
                int n8 = byteBuf.readerIndex();
                int n10 = byteBuf.writerIndex() - n8;
                if (n10 > 0) {
                    int n11;
                    if (l2 - (long)n10 < l10 && n7 != 0) break;
                    l10 += (long)n10;
                    int n12 = channelOutboundBuffer$Entry.count;
                    if (n12 == -1) {
                        channelOutboundBuffer$Entry.count = n12 = byteBuf.nioBufferCount();
                    }
                    if ((n11 = Math.min(n4, n7 + n12)) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n11, n7);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n12 == 1) {
                        ByteBuffer byteBuffer = channelOutboundBuffer$Entry.buf;
                        if (byteBuffer == null) {
                            channelOutboundBuffer$Entry.buf = byteBuffer = byteBuf.internalNioBuffer(n8, n10);
                        }
                        byteBufferArray[n7++] = byteBuffer;
                    } else {
                        n7 = ChannelOutboundBuffer.nioBuffers(channelOutboundBuffer$Entry, byteBuf, byteBufferArray, n7, n4);
                    }
                    if (n7 == n4) break;
                }
            }
            channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next;
        }
        this.nioBufferCount = n7;
        this.nioBufferSize = l10;
        return byteBufferArray;
    }

    private static int nioBuffers(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry, ByteBuf byteBuf, ByteBuffer[] byteBufferArray, int n4, int n7) {
        ByteBuffer byteBuffer;
        ByteBuffer[] byteBufferArray2 = channelOutboundBuffer$Entry.bufs;
        if (byteBufferArray2 == null) {
            channelOutboundBuffer$Entry.bufs = byteBufferArray2 = byteBuf.nioBuffers();
        }
        for (int i3 = 0; i3 < byteBufferArray2.length && n4 < n7 && (byteBuffer = byteBufferArray2[i3]) != null; ++i3) {
            if (!byteBuffer.hasRemaining()) continue;
            byteBufferArray[n4++] = byteBuffer;
        }
        return n4;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n4, int n7) {
        int n8 = byteBufferArray.length;
        do {
            if ((n8 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n4 > n8);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n8];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n7);
        return byteBufferArray2;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public boolean getUserDefinedWritability(int n4) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n4)) == 0;
    }

    public void setUserDefinedWritability(int n4, boolean bl3) {
        if (bl3) {
            this.setUserDefinedWritability(n4);
        } else {
            this.clearUserDefinedWritability(n4);
        }
    }

    private void setUserDefinedWritability(int n4) {
        block1: {
            int n7;
            int n8;
            int n10 = ~ChannelOutboundBuffer.writabilityMask(n4);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n8 = this.unwritable, n7 = n8 & n10)) {
            }
            if (n8 == 0 || n7 != 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private void clearUserDefinedWritability(int n4) {
        block1: {
            int n7;
            int n8;
            int n10 = ChannelOutboundBuffer.writabilityMask(n4);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n8 = this.unwritable, n7 = n8 | n10)) {
            }
            if (n8 != 0 || n7 == 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private static int writabilityMask(int n4) {
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("index: " + n4 + " (expected: 1~31)");
        }
        return 1 << n4;
    }

    private void setWritable(boolean bl3) {
        block1: {
            int n4;
            int n7;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n7 = this.unwritable, n4 = n7 & 0xFFFFFFFE)) {
            }
            if (n7 == 0 || n4 != 0) break block1;
            this.fireChannelWritabilityChanged(bl3);
        }
    }

    private void setUnwritable(boolean bl3) {
        block1: {
            int n4;
            int n7;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n7 = this.unwritable, n4 = n7 | 1)) {
            }
            if (n7 != 0 || n4 == 0) break block1;
            this.fireChannelWritabilityChanged(bl3);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl3) {
        ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl3) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new ChannelOutboundBuffer$2(this, channelPipeline);
            }
            this.channel.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    public int size() {
        return this.flushed;
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    void failFlushed(Throwable throwable, boolean bl3) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl3)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Throwable throwable, boolean bl3) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new ChannelOutboundBuffer$3(this, throwable, bl3));
            return;
        }
        this.inFail = true;
        if (!bl3 && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry; channelOutboundBuffer$Entry != null; channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.recycleAndGetNext()) {
                int n4 = channelOutboundBuffer$Entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n4);
                if (channelOutboundBuffer$Entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(channelOutboundBuffer$Entry.msg);
                ChannelOutboundBuffer.safeFail(channelOutboundBuffer$Entry.promise, throwable);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    void close(ClosedChannelException closedChannelException) {
        this.close(closedChannelException, false);
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        PromiseNotificationUtil.trySuccess(channelPromise, null, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Deprecated
    public void recycle() {
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public long bytesBeforeUnwritable() {
        long l2 = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l2 > 0L) {
            return this.isWritable() ? l2 : 0L;
        }
        return 0L;
    }

    public long bytesBeforeWritable() {
        long l2 = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (l2 > 0L) {
            return this.isWritable() ? 0L : l2;
        }
        return 0L;
    }

    public void forEachFlushedMessage(ChannelOutboundBuffer$MessageProcessor channelOutboundBuffer$MessageProcessor) {
        if (channelOutboundBuffer$MessageProcessor == null) {
            throw new NullPointerException("processor");
        }
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return;
        }
        do {
            if (channelOutboundBuffer$Entry.cancelled || channelOutboundBuffer$MessageProcessor.processMessage(channelOutboundBuffer$Entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next));
    }

    private boolean isFlushedEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        return channelOutboundBuffer$Entry != null && channelOutboundBuffer$Entry != this.unflushedEntry;
    }
}

