/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelInitializer$1;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler$Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);
    private final Set<ChannelHandlerContext> initMap = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void initChannel(C var1);

    @Override
    public final void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (this.initChannel(channelHandlerContext)) {
            channelHandlerContext.pipeline().fireChannelRegistered();
            this.removeState(channelHandlerContext);
        } else {
            channelHandlerContext.fireChannelRegistered();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to initialize a channel. Closing: " + channelHandlerContext.channel(), throwable);
        }
        channelHandlerContext.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isRegistered() && this.initChannel(channelHandlerContext)) {
            this.removeState(channelHandlerContext);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.initMap.remove(channelHandlerContext);
    }

    private boolean initChannel(ChannelHandlerContext channelHandlerContext) {
        if (this.initMap.add(channelHandlerContext)) {
            try {
                this.initChannel(channelHandlerContext.channel());
            }
            catch (Throwable throwable) {
                this.exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
                if (channelPipeline.context(this) != null) {
                    channelPipeline.remove(this);
                }
            }
            return true;
        }
        return false;
    }

    private void removeState(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.isRemoved()) {
            this.initMap.remove(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(new ChannelInitializer$1(this, channelHandlerContext));
        }
    }

    static /* synthetic */ Set access$000(ChannelInitializer channelInitializer) {
        return channelInitializer.initMap;
    }
}

