/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerMask$1;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerMask$2;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.security.AccessController;
import java.util.Map;

final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    static final int MASK_EXCEPTION_CAUGHT = 1;
    static final int MASK_CHANNEL_REGISTERED = 2;
    static final int MASK_CHANNEL_UNREGISTERED = 4;
    static final int MASK_CHANNEL_ACTIVE = 8;
    static final int MASK_CHANNEL_INACTIVE = 16;
    static final int MASK_CHANNEL_READ = 32;
    static final int MASK_CHANNEL_READ_COMPLETE = 64;
    static final int MASK_USER_EVENT_TRIGGERED = 128;
    static final int MASK_CHANNEL_WRITABILITY_CHANGED = 256;
    static final int MASK_BIND = 512;
    static final int MASK_CONNECT = 1024;
    static final int MASK_DISCONNECT = 2048;
    static final int MASK_CLOSE = 4096;
    static final int MASK_DEREGISTER = 8192;
    static final int MASK_READ = 16384;
    static final int MASK_WRITE = 32768;
    static final int MASK_FLUSH = 65536;
    private static final int MASK_ALL_INBOUND = 511;
    private static final int MASK_ALL_OUTBOUND = 130561;
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new ChannelHandlerMask$1();

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map<Class<? extends ChannelHandler>, Integer> map = MASKS.get();
        Integer n4 = map.get(clazz);
        if (n4 == null) {
            n4 = ChannelHandlerMask.mask0(clazz);
            map.put(clazz, n4);
        }
        return n4;
    }

    private static int mask0(Class<? extends ChannelHandler> clazz) {
        int n4 = 1;
        try {
            if (ChannelInboundHandler.class.isAssignableFrom(clazz)) {
                n4 |= 0x1FF;
                if (ChannelHandlerMask.isSkippable(clazz, "channelRegistered", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFFFD;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelUnregistered", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFFFB;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelActive", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFFF7;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelInactive", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFFEF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelRead", ChannelHandlerContext.class, Object.class)) {
                    n4 &= 0xFFFFFFDF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelReadComplete", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFFBF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelWritabilityChanged", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFFEFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "userEventTriggered", ChannelHandlerContext.class, Object.class)) {
                    n4 &= 0xFFFFFF7F;
                }
            }
            if (ChannelOutboundHandler.class.isAssignableFrom(clazz)) {
                n4 |= 0x1FE01;
                if (ChannelHandlerMask.isSkippable(clazz, "bind", ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class)) {
                    n4 &= 0xFFFFFDFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "connect", ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class)) {
                    n4 &= 0xFFFFFBFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "disconnect", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n4 &= 0xFFFFF7FF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "close", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n4 &= 0xFFFFEFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "deregister", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n4 &= 0xFFFFDFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "read", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFFBFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "write", ChannelHandlerContext.class, Object.class, ChannelPromise.class)) {
                    n4 &= 0xFFFF7FFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "flush", ChannelHandlerContext.class)) {
                    n4 &= 0xFFFEFFFF;
                }
            }
            if (ChannelHandlerMask.isSkippable(clazz, "exceptionCaught", ChannelHandlerContext.class, Throwable.class)) {
                n4 &= 0xFFFFFFFE;
            }
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return n4;
    }

    private static boolean isSkippable(Class<?> clazz, String string, Class<?> ... classArray) {
        return AccessController.doPrivileged(new ChannelHandlerMask$2(clazz, string, classArray));
    }

    private ChannelHandlerMask() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

