/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.AbstractChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannelHandlerContext$1;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;

abstract class AbstractChannelHandlerContext$AbstractWriteTask
implements Runnable {
    private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.transport.estimateSizeOnSubmit", true);
    private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.transport.writeTaskSizeOverhead", 48);
    private final Recycler$Handle<AbstractChannelHandlerContext$AbstractWriteTask> handle;
    private AbstractChannelHandlerContext ctx;
    private Object msg;
    private ChannelPromise promise;
    private int size;

    private AbstractChannelHandlerContext$AbstractWriteTask(Recycler$Handle<? extends AbstractChannelHandlerContext$AbstractWriteTask> recycler$Handle) {
        this.handle = recycler$Handle;
    }

    protected static void init(AbstractChannelHandlerContext$AbstractWriteTask abstractChannelHandlerContext$AbstractWriteTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
        abstractChannelHandlerContext$AbstractWriteTask.ctx = abstractChannelHandlerContext;
        abstractChannelHandlerContext$AbstractWriteTask.msg = object;
        abstractChannelHandlerContext$AbstractWriteTask.promise = channelPromise;
        if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
            abstractChannelHandlerContext$AbstractWriteTask.size = AbstractChannelHandlerContext.access$1600(abstractChannelHandlerContext).estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
            AbstractChannelHandlerContext.access$1600(abstractChannelHandlerContext).incrementPendingOutboundBytes(abstractChannelHandlerContext$AbstractWriteTask.size);
        } else {
            abstractChannelHandlerContext$AbstractWriteTask.size = 0;
        }
    }

    @Override
    public final void run() {
        try {
            this.decrementPendingOutboundBytes();
            this.write(this.ctx, this.msg, this.promise);
        }
        finally {
            this.recycle();
        }
    }

    void cancel() {
        try {
            this.decrementPendingOutboundBytes();
        }
        finally {
            this.recycle();
        }
    }

    private void decrementPendingOutboundBytes() {
        if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
            AbstractChannelHandlerContext.access$1600(this.ctx).decrementPendingOutboundBytes(this.size);
        }
    }

    private void recycle() {
        this.ctx = null;
        this.msg = null;
        this.promise = null;
        this.handle.recycle(this);
    }

    protected void write(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
        AbstractChannelHandlerContext.access$1700(abstractChannelHandlerContext, object, channelPromise);
    }

    /* synthetic */ AbstractChannelHandlerContext$AbstractWriteTask(Recycler$Handle recycler$Handle, AbstractChannelHandlerContext$1 abstractChannelHandlerContext$1) {
        this(recycler$Handle);
    }
}

