/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel;

import io.grpc.netty.shaded.io.netty.channel.AbstractChannel;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$1;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$2;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$3;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$4;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$5;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$6;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$7;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$8;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AbstractUnsafe$9;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AnnotatedConnectException;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AnnotatedNoRouteToHostException;
import io.grpc.netty.shaded.io.netty.channel.AbstractChannel$AnnotatedSocketException;
import io.grpc.netty.shaded.io.netty.channel.Channel$Unsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.VoidChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.grpc.netty.shaded.io.netty.channel.socket.ChannelOutputShutdownException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel$AbstractUnsafe
implements Channel$Unsafe {
    private volatile ChannelOutboundBuffer outboundBuffer;
    private RecvByteBufAllocator.Handle recvHandle;
    private boolean inFlush0;
    private boolean neverRegistered;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractChannel this$0;

    protected AbstractChannel$AbstractUnsafe(AbstractChannel abstractChannel) {
        this.this$0 = abstractChannel;
        this.outboundBuffer = new ChannelOutboundBuffer(this.this$0);
        this.neverRegistered = true;
    }

    private void assertEventLoop() {
        if (!$assertionsDisabled && AbstractChannel.access$000(this.this$0) && !AbstractChannel.access$100(this.this$0).inEventLoop()) {
            throw new AssertionError();
        }
    }

    @Override
    public RecvByteBufAllocator.Handle recvBufAllocHandle() {
        if (this.recvHandle == null) {
            this.recvHandle = this.this$0.config().getRecvByteBufAllocator().newHandle();
        }
        return this.recvHandle;
    }

    @Override
    public final ChannelOutboundBuffer outboundBuffer() {
        return this.outboundBuffer;
    }

    @Override
    public final SocketAddress localAddress() {
        return this.this$0.localAddress0();
    }

    @Override
    public final SocketAddress remoteAddress() {
        return this.this$0.remoteAddress0();
    }

    @Override
    public final void register(EventLoop eventLoop, ChannelPromise channelPromise) {
        if (eventLoop == null) {
            throw new NullPointerException("eventLoop");
        }
        if (this.this$0.isRegistered()) {
            channelPromise.setFailure(new IllegalStateException("registered to an event loop already"));
            return;
        }
        if (!this.this$0.isCompatible(eventLoop)) {
            channelPromise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
            return;
        }
        AbstractChannel.access$102(this.this$0, eventLoop);
        if (eventLoop.inEventLoop()) {
            this.register0(channelPromise);
        } else {
            try {
                eventLoop.execute(new AbstractChannel$AbstractUnsafe$1(this, channelPromise));
            }
            catch (Throwable throwable) {
                AbstractChannel.access$300().warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)this.this$0, (Object)throwable);
                this.closeForcibly();
                AbstractChannel.access$400(this.this$0).setClosed();
                this.safeSetFailure(channelPromise, throwable);
            }
        }
    }

    private void register0(ChannelPromise channelPromise) {
        try {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            boolean bl3 = this.neverRegistered;
            this.this$0.doRegister();
            this.neverRegistered = false;
            AbstractChannel.access$002(this.this$0, true);
            AbstractChannel.access$500(this.this$0).invokeHandlerAddedIfNeeded();
            this.safeSetSuccess(channelPromise);
            AbstractChannel.access$500(this.this$0).fireChannelRegistered();
            if (this.this$0.isActive()) {
                if (bl3) {
                    AbstractChannel.access$500(this.this$0).fireChannelActive();
                } else if (this.this$0.config().isAutoRead()) {
                    this.beginRead();
                }
            }
        }
        catch (Throwable throwable) {
            this.closeForcibly();
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetFailure(channelPromise, throwable);
        }
    }

    @Override
    public final void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        this.assertEventLoop();
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        if (Boolean.TRUE.equals(this.this$0.config().getOption(ChannelOption.SO_BROADCAST)) && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.maybeSuperUser()) {
            AbstractChannel.access$300().warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + socketAddress + ") anyway as requested.");
        }
        boolean bl3 = this.this$0.isActive();
        try {
            this.this$0.doBind(socketAddress);
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            this.closeIfClosed();
            return;
        }
        if (!bl3 && this.this$0.isActive()) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$2(this));
        }
        this.safeSetSuccess(channelPromise);
    }

    @Override
    public final void disconnect(ChannelPromise channelPromise) {
        this.assertEventLoop();
        if (!channelPromise.setUncancellable()) {
            return;
        }
        boolean bl3 = this.this$0.isActive();
        try {
            this.this$0.doDisconnect();
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            this.closeIfClosed();
            return;
        }
        if (bl3 && !this.this$0.isActive()) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$3(this));
        }
        this.safeSetSuccess(channelPromise);
        this.closeIfClosed();
    }

    @Override
    public final void close(ChannelPromise channelPromise) {
        this.assertEventLoop();
        ClosedChannelException closedChannelException = new ClosedChannelException();
        this.close(channelPromise, closedChannelException, closedChannelException, false);
    }

    public final void shutdownOutput(ChannelPromise channelPromise) {
        this.assertEventLoop();
        this.shutdownOutput(channelPromise, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownOutput(ChannelPromise channelPromise, Throwable throwable) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            channelPromise.setFailure(new ClosedChannelException());
            return;
        }
        this.outboundBuffer = null;
        ChannelOutputShutdownException channelOutputShutdownException = throwable == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", throwable);
        Executor executor = this.prepareToClose();
        if (executor != null) {
            executor.execute(new AbstractChannel$AbstractUnsafe$4(this, channelPromise, channelOutboundBuffer, channelOutputShutdownException));
        } else {
            try {
                this.this$0.doShutdownOutput();
                channelPromise.setSuccess();
            }
            catch (Throwable throwable2) {
                channelPromise.setFailure(throwable2);
            }
            finally {
                this.closeOutboundBufferForShutdown(AbstractChannel.access$500(this.this$0), channelOutboundBuffer, channelOutputShutdownException);
            }
        }
    }

    private void closeOutboundBufferForShutdown(ChannelPipeline channelPipeline, ChannelOutboundBuffer channelOutboundBuffer, Throwable throwable) {
        channelOutboundBuffer.failFlushed(throwable, false);
        channelOutboundBuffer.close(throwable, true);
        channelPipeline.fireUserEventTriggered(ChannelOutputShutdownEvent.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ChannelPromise channelPromise, Throwable throwable, ClosedChannelException closedChannelException, boolean bl3) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (AbstractChannel.access$700(this.this$0)) {
            if (AbstractChannel.access$400(this.this$0).isDone()) {
                this.safeSetSuccess(channelPromise);
            } else if (!(channelPromise instanceof VoidChannelPromise)) {
                AbstractChannel.access$400(this.this$0).addListener((GenericFutureListener)new AbstractChannel$AbstractUnsafe$5(this, channelPromise));
            }
            return;
        }
        AbstractChannel.access$702(this.this$0, true);
        boolean bl4 = this.this$0.isActive();
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        this.outboundBuffer = null;
        Executor executor = this.prepareToClose();
        if (executor != null) {
            executor.execute(new AbstractChannel$AbstractUnsafe$6(this, channelPromise, channelOutboundBuffer, throwable, bl3, closedChannelException, bl4));
        } else {
            try {
                this.doClose0(channelPromise);
            }
            finally {
                if (channelOutboundBuffer != null) {
                    channelOutboundBuffer.failFlushed(throwable, bl3);
                    channelOutboundBuffer.close(closedChannelException);
                }
            }
            if (this.inFlush0) {
                this.invokeLater(new AbstractChannel$AbstractUnsafe$7(this, bl4));
            } else {
                this.fireChannelInactiveAndDeregister(bl4);
            }
        }
    }

    private void doClose0(ChannelPromise channelPromise) {
        try {
            this.this$0.doClose();
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetSuccess(channelPromise);
        }
        catch (Throwable throwable) {
            AbstractChannel.access$400(this.this$0).setClosed();
            this.safeSetFailure(channelPromise, throwable);
        }
    }

    private void fireChannelInactiveAndDeregister(boolean bl3) {
        this.deregister(this.voidPromise(), bl3 && !this.this$0.isActive());
    }

    @Override
    public final void closeForcibly() {
        this.assertEventLoop();
        try {
            this.this$0.doClose();
        }
        catch (Exception exception) {
            AbstractChannel.access$300().warn("Failed to close a channel.", exception);
        }
    }

    @Override
    public final void deregister(ChannelPromise channelPromise) {
        this.assertEventLoop();
        this.deregister(channelPromise, false);
    }

    private void deregister(ChannelPromise channelPromise, boolean bl3) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (!AbstractChannel.access$000(this.this$0)) {
            this.safeSetSuccess(channelPromise);
            return;
        }
        this.invokeLater(new AbstractChannel$AbstractUnsafe$8(this, bl3, channelPromise));
    }

    @Override
    public final void beginRead() {
        this.assertEventLoop();
        if (!this.this$0.isActive()) {
            return;
        }
        try {
            this.this$0.doBeginRead();
        }
        catch (Exception exception) {
            this.invokeLater(new AbstractChannel$AbstractUnsafe$9(this, exception));
            this.close(this.voidPromise());
        }
    }

    @Override
    public final void write(Object object, ChannelPromise channelPromise) {
        int n4;
        this.assertEventLoop();
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.access$1100(this.this$0)));
            ReferenceCountUtil.release(object);
            return;
        }
        try {
            object = this.this$0.filterOutboundMessage(object);
            n4 = AbstractChannel.access$500(this.this$0).estimatorHandle().size(object);
            if (n4 < 0) {
                n4 = 0;
            }
        }
        catch (Throwable throwable) {
            this.safeSetFailure(channelPromise, throwable);
            ReferenceCountUtil.release(object);
            return;
        }
        channelOutboundBuffer.addMessage(object, n4, channelPromise);
    }

    @Override
    public final void flush() {
        this.assertEventLoop();
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null) {
            return;
        }
        channelOutboundBuffer.addFlush();
        this.flush0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush0() {
        if (this.inFlush0) {
            return;
        }
        ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
        if (channelOutboundBuffer == null || channelOutboundBuffer.isEmpty()) {
            return;
        }
        this.inFlush0 = true;
        if (!this.this$0.isActive()) {
            try {
                if (this.this$0.isOpen()) {
                    channelOutboundBuffer.failFlushed(new NotYetConnectedException(), true);
                } else {
                    channelOutboundBuffer.failFlushed(this.newClosedChannelException(AbstractChannel.access$1100(this.this$0)), false);
                }
            }
            finally {
                this.inFlush0 = false;
            }
            return;
        }
        try {
            this.this$0.doWrite(channelOutboundBuffer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException && this.this$0.config().isAutoClose()) {
                AbstractChannel.access$1102(this.this$0, throwable);
                this.close(this.voidPromise(), throwable, this.newClosedChannelException(throwable), false);
            } else {
                try {
                    this.shutdownOutput(this.voidPromise(), throwable);
                }
                catch (Throwable throwable2) {
                    AbstractChannel.access$1102(this.this$0, throwable);
                    this.close(this.voidPromise(), throwable2, this.newClosedChannelException(throwable), false);
                }
            }
        }
        finally {
            this.inFlush0 = false;
        }
    }

    private ClosedChannelException newClosedChannelException(Throwable throwable) {
        ClosedChannelException closedChannelException = new ClosedChannelException();
        if (throwable != null) {
            closedChannelException.initCause(throwable);
        }
        return closedChannelException;
    }

    @Override
    public final ChannelPromise voidPromise() {
        this.assertEventLoop();
        return AbstractChannel.access$1200(this.this$0);
    }

    protected final boolean ensureOpen(ChannelPromise channelPromise) {
        if (this.this$0.isOpen()) {
            return true;
        }
        this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.access$1100(this.this$0)));
        return false;
    }

    protected final void safeSetSuccess(ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
            AbstractChannel.access$300().warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
        }
    }

    protected final void safeSetFailure(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            AbstractChannel.access$300().warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    protected final void closeIfClosed() {
        if (this.this$0.isOpen()) {
            return;
        }
        this.close(this.voidPromise());
    }

    private void invokeLater(Runnable runnable) {
        try {
            this.this$0.eventLoop().execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AbstractChannel.access$300().warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
        }
    }

    protected final Throwable annotateConnectException(Throwable throwable, SocketAddress socketAddress) {
        if (throwable instanceof ConnectException) {
            return new AbstractChannel$AnnotatedConnectException((ConnectException)throwable, socketAddress);
        }
        if (throwable instanceof NoRouteToHostException) {
            return new AbstractChannel$AnnotatedNoRouteToHostException((NoRouteToHostException)throwable, socketAddress);
        }
        if (throwable instanceof SocketException) {
            return new AbstractChannel$AnnotatedSocketException((SocketException)throwable, socketAddress);
        }
        return throwable;
    }

    protected Executor prepareToClose() {
        return null;
    }

    static /* synthetic */ void access$200(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, ChannelPromise channelPromise) {
        abstractChannel$AbstractUnsafe.register0(channelPromise);
    }

    static /* synthetic */ void access$600(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, ChannelPipeline channelPipeline, ChannelOutboundBuffer channelOutboundBuffer, Throwable throwable) {
        abstractChannel$AbstractUnsafe.closeOutboundBufferForShutdown(channelPipeline, channelOutboundBuffer, throwable);
    }

    static /* synthetic */ void access$800(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, ChannelPromise channelPromise) {
        abstractChannel$AbstractUnsafe.doClose0(channelPromise);
    }

    static /* synthetic */ void access$900(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, boolean bl3) {
        abstractChannel$AbstractUnsafe.fireChannelInactiveAndDeregister(bl3);
    }

    static /* synthetic */ void access$1000(AbstractChannel$AbstractUnsafe abstractChannel$AbstractUnsafe, Runnable runnable) {
        abstractChannel$AbstractUnsafe.invokeLater(runnable);
    }

    static {
        $assertionsDisabled = !AbstractChannel.class.desiredAssertionStatus();
    }
}

